package com.sun.enterprise.tools.verifier.tests.ejb.runtime.resource;

/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;

/** ejb [0,n]
 *  resource-env-ref [0,n]
 *      resource-env-ref-name [String]
 *      jndi-name [String]
 *
 * The resource-env-ref holds all the runtime bindings for a resource
 * environment reference
 *
 *
 * @author Irfan Ahmed
 */

public class ASEjbResEnvRef extends EjbTest implements EjbCheck
 {
    public Result result;
    public ComponentNameConstructor compName;
    public Result check(EjbDescriptor descriptor)
    {
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();
        try {
        int ejbResEnvReference = getCountNodeSet("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/resource-env-ref");
        if (ejbResEnvReference>0)
        {
            for (int i=1;i<=ejbResEnvReference;i++)
            {
                String refName = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/resource-env-ref["+i+"]/resource-env-ref-name");
                try
                {
                    descriptor.getJmsDestinationReferenceByName(refName);
                    result.passed(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.passed(smh.getLocalString(getClass().getName()+".passed",
                            "PASSED [AS-EJB resource-env-ref] : res-env-ref-name {0} is verified with ejb-jar.xml",
                            new Object[]{refName}));
                }catch(IllegalArgumentException iaex)
                {
                    Verifier.debug(iaex);
                    result.failed(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.failed(smh.getLocalString(getClass().getName()+".failed",
                            "FAILED [AS-EJB resource-env-ref] : The res-env-ref-name {0} is not defined in ejb-jar.xml for this bean",
                            new Object[]{refName}));
                }
            }
         }
        else
        {
            addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString
                    (getClass().getName() + ".notApplicable",
                            " NOT-APPLICABLE: {0} Does not define any resource-env-ref Elements",
                            new Object[] {descriptor.getName()}));
        }
        } catch(Exception ex){
            result.addErrorDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.failed(smh.getLocalString(getClass().getName()+".notRun",
                    "NOT RUN [AS-EJB] Could not create descriptor Object."));
        }
        return result;
    }
}
