/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import java.lang.reflect.Method;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
/** 
 * Stateless session beans home interface create method return test.
 * The home interface of a stateless session Bean must have a create method that
 * takes no arguments, and returns the session Bean's remote interface. 
 */
public class StatelessCreateReturn extends EjbTest implements EjbCheck { 
    boolean foundAtLeastOneCreate = false;
    Result result = null;
    ComponentNameConstructor compName = null;

    /**
     * Stateless session beans home interface create method return test.
     * The home interface of a stateless session Bean must have a create method that
     * takes no arguments, and returns the session Bean's remote interface. 
     *    
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();

        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionType();
            if (EjbSessionDescriptor.STATELESS.equals(stateType)) {
                // RULE: Stateless session are only allowed to have create
                //       methods with no arguments, and returns the session Bean's
                //       remote interface. The home interface must not have any
                //       other create methods.
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) &&
                        descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName()) )
                    commonToBothInterfaces(descriptor.getRemoteClassName(),descriptor.getHomeClassName(),(EjbSessionDescriptor)descriptor);

                if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())&&
                        descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName()))
                    commonToBothInterfaces(descriptor.getLocalClassName(),descriptor.getLocalHomeClassName() ,(EjbSessionDescriptor)descriptor);

                if(result.getStatus() != Result.FAILED) {
                    addGoodDetails(result, compName);
                    result.passed(smh.getLocalString
                            (getClass().getName() +".passed",
                                    "create method is properly defined in the remote/local home interface"));
                }
                return result;
            }
        }
        return result;
    }

    /**
     * This method is responsible for the logic of the test. It is called for both local and remote interfaces.
     * @param descriptor the Enterprise Java Bean deployment descriptor
     * @param home for the Home interface of the Ejb. 
     * @param remote Remote/Local interface
     */

    private void commonToBothInterfaces(String remote, String home, EjbSessionDescriptor descriptor) {
        try {
            Class c = Class.forName(home, false, getVerifierContext().getClassLoader());
            for (Method methods : c.getDeclaredMethods()) {
                if (methods.getName().startsWith("create")) {
                    Class methodReturnType = methods.getReturnType();
                    if (!(methodReturnType.getName().equals(remote))) {
                        addErrorDetails(result, compName);
                        result.addErrorDetails(smh.getLocalString
                                (getClass().getName() + ".debug1",
                                        "For Home Interface [ {0} ] Method [ {1} ]",
                                        new Object[] {home,methods.getName()}));
                        result.addErrorDetails(smh.getLocalString
                                (getClass().getName() + ".failed",
                                        "Error: A Create method was found, but the " +
                                "return type [ {0} ] was not the Remote/Local interface" ,
                                        new Object[] {methodReturnType.getName()}));

                    }
                }
            }
        } catch (ClassNotFoundException e) {
            Verifier.debug(e);
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failedException",
                            "Error: Home/Local Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]",
                            new Object[] {home, descriptor.getName()}));
        }
    }
}
