/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JarFileDependsOnOutsidePackage.java
 *
 * Created on August 30, 2004, 10:16 AM
 */

package com.sun.enterprise.tools.verifier.tests.util;

import com.sun.enterprise.tools.verifier.Result;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/**
 *
 * @author  ss141213
 * This as per J2EE 1.4 spec section#8.2. Contents from spec is given below...
 * Only Jar format files containing class files or resources to be loaded directly 
 * by a standard ClassLoader should be the target of a Class-Path reference; 
 * such files are always named with a .jar extension. 
 * Top level Jar files that are processed by a deployment tool 
 * should not contain Class-Path entries; 
 * such entries would, by definition, 
 * reference other files external to the deployment unit. 
 * A deployment tool is not required to process such external references.
  */
public class BundledOptPkgHasDependencies {
    public static void test(String explodedJarPath, Result result){
        try{
            boolean failed=false;
            Manifest manifest=new Manifest(new FileInputStream(new File(explodedJarPath+File.separator+JarFile.MANIFEST_NAME)));
            String depClassPath=manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if(depClassPath!=null){
                for(StringTokenizer st=new StringTokenizer(depClassPath);st.hasMoreTokens();){
                    String entry=st.nextToken();
                    String entryPath=new File(explodedJarPath).getParent()+File.separator+entry;
                    File bundledOptPkg=new File(entryPath);
                    if(!bundledOptPkg.isDirectory()){
                        Manifest bundledManifest=new JarFile(bundledOptPkg).getManifest();
                        String bundledCP=bundledManifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if(bundledCP!=null && bundledCP.length()!=0){
                            failed=true;
                            result.failed(entry + " contains Class-Path in it's manifest.");
                        }
                    }
                }
            }//if
            if(!failed){
                result.setStatus(Result.PASSED);
            }
        }catch(Exception e){
            result.failed(e.toString());
        }
    }
}
