/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AllJSPsMustBeCompilable.java
 *
 * Created on August 27, 2004, 11:57 AM
 */

package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

import java.io.File;
import java.util.logging.Level;
import java.util.List;

import org.apache.jasper.JspC;
import org.apache.jasper.JasperException;
/**
 *
 * @author  ss141213
 */
public class AllJSPsMustBeCompilable extends WebTest implements WebCheck{

    public Result check(WebBundleDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        // initialize good result
        addGoodDetails(result, compName);
        result.addGoodDetails(smh.getLocalString(getClass().getName() + ".passed",
                                "All JSPs are compilable."));
        // set default status to PASSED
        result.setStatus(Result.PASSED);
        // initialize error results.
        addErrorDetails(result, compName);
        result.addErrorDetails(smh.getLocalString(getClass().getName() + ".exception",
                "Error: Some JSPs bundled inside [ {0} ] could not be compiled. See details below.",
                new Object[] {descriptor.getName()}));
        for(JasperException e : compile(descriptor)){
            result.failed(formatMessage(descriptor, e.toString()));
        }
        return result;
    }

    protected List<JasperException> compile(WebBundleDescriptor descriptor) {
        String archiveUri = getAbstractArchiveUri(descriptor);
        File outDir=getVerifierContext().getOutDir();
        logger.log(Level.INFO, "Compiling JSPs in [ " +new File(archiveUri).getName()+ " ]");
        JspC jspc=new JspC();
        jspc.setUriroot(archiveUri);
        jspc.setCompile(true);
        jspc.setOutputDir(outDir.getAbsolutePath());
        jspc.setFailOnError(false);
        String as_lib_root=System.getProperty("com.sun.aas.installRoot")+File.separator+"lib"+File.separator;
        String cp = getVerifierContext().getClassPath();
        if (!getVerifierContext().isAppserverMode()) {
            cp = as_lib_root+"javaee.jar"+ File.pathSeparator + cp;
        }
        logger.log(Level.FINE, "JSPC classpath "+cp);
        jspc.setSystemClassPath(cp);
        jspc.setSchemaResourcePrefix("/schemas/");
        jspc.setDtdResourcePrefix("/dtds/");
        if (logger.isLoggable(Level.FINEST)) 
            jspc.setVerbose(1);
        try {
            jspc.execute();
        } catch(JasperException je) {
            List<JasperException> errors = jspc.getJSPCompilationErrors();
            errors.add(je);
            return errors;
        }
        return jspc.getJSPCompilationErrors();
    }
    
    private String formatMessage(WebBundleDescriptor descriptor, String message) {
        if (message == null || descriptor == null) return null;
        String formattedMessage = message;
        String archiveUri = getAbstractArchiveUri(descriptor);
        int index = message.indexOf(archiveUri);
        if(index != -1) {
            formattedMessage = message.substring(index + archiveUri.length() + 1);
        }
        return formattedMessage;
    }
    
}
