/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;


import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;

import java.util.Enumeration;
import java.util.Vector;



/**
 *
 *  @author Jerome Dochez
 */
public class FilterInitParamValue extends WebTest implements WebCheck {

    /**
     * Param Value exists test.
     *
     * @param descriptor the Web deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        boolean oneWarning = false, onePassed = false;

        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
        if (filterEnum.hasMoreElements()) {
            // get the filters in this .war
            while (filterEnum.hasMoreElements()) {
                ServletFilterDescriptor filter = (ServletFilterDescriptor) filterEnum.nextElement();
                Vector epVector = filter.getInitializationParameters();

                if (epVector.size() != 0) {
                    for ( int i = 0; i < epVector.size(); i++) {
                        EnvironmentProperty ep = (EnvironmentProperty)epVector.elementAt(i);
                        String epValue = ep.getValue();
                        if (epValue.length() != 0) {
                            onePassed=true;
                            addGoodDetails(result, compName);
                            result.addGoodDetails(smh.getLocalString
                                              ("com.sun.enterprise.tools.verifier.tests.web.FilterInitParamValue" + ".passed",
                                               "Param value exists for the filter [ {0} ].",
                                               new Object[] {filter.getName()}));
                        } else {
                            oneWarning = true;
                            addWarningDetails(result, compName);
                            result.addWarningDetails(smh.getLocalString
                                    ("com.sun.enterprise.tools.verifier.tests.web.FilterInitParamValue" + ".warning",
                                            "WARNING: Param value entry for the filter [ {0} ] should be of finite length.",
                                            new Object[] {filter.getName()}));
                        }
                    }
                } else {
                    addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString
                            ("com.sun.enterprise.tools.verifier.tests.web.FilterInitParamValue" + ".notApplicable",
                                    "There are no initialization parameters for the filter [ {0} ] within the web archive [ {1} ]",
                                    new Object[] {filter.getName(), descriptor.getName()}));

                }
            }
            if (oneWarning) {
                result.setStatus(Result.WARNING);
            } else if (onePassed){
                result.setStatus(Result.PASSED);
            }
        } else {
            result.addNaDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.notApplicable(smh.getLocalString
                    ("com.sun.enterprise.tools.verifier.tests.web.FilterInitParamValue" + ".notApplicable1",
                            "There are no filters defined within the web archive [ {0} ]",
                            new Object[] {descriptor.getName()}));
        }
        return result;
    }
}
