/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;

/** 
 * The Web form-login-page value defines the location in the web application 
 * where the page can be used for login page can be found within web application
 * test
 */
public class FormLoginPage extends WebTest implements WebCheck { 

    
    /** 
     * The Web form-login-page value defines the location in the web application 
     * where the page can be used for login page can be found within web application
     * test
     *
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor.getLoginConfiguration() != null) {
	    boolean foundIt = false;
//            ZipEntry ze = null;
//            JarFile jar =null;
            FileArchive arch=null;
	    
            String formLoginPage = descriptor.getLoginConfiguration().getFormLoginPage();
            if (formLoginPage.length() > 0) {
	       
                try{
//                    File f = Verifier.getArchiveFile(descriptor.getModuleDescriptor().getArchiveUri());
//                    if(f==null){
                        String uri=getAbstractArchiveUri(descriptor);
                        try{
                            arch = new FileArchive();
                            arch.open(uri);
                        }catch(IOException e){throw e;}
//                    }else{
//                        jar = new JarFile(f);
//                    }
                    if (formLoginPage.startsWith("/")) 
                        formLoginPage=formLoginPage.substring(1);
//                        if (f!=null){
//                        ze = jar.getEntry(formLoginPage);
//                        foundIt = (ze != null);
//                    }
//                    else{
                        File flp = new File(arch.getArchiveUri()+File.separator+formLoginPage);
                        if(flp.exists())
                            foundIt=true;
                        flp = null;
//                    }
//                    if (jar!=null)
//                        jar.close();
                }catch (Exception ex) {
		    //should be aldready set?
		    foundIt = false;
	        }
               
	        if (foundIt) {
		    result.addGoodDetails(smh.getLocalString
			("tests.componentNameConstructor",
			"For [ {0} ]",
			new Object[] {compName.toString()}));	
		    result.passed(smh.getLocalString
			          (getClass().getName() + ".passed",
			           "The form-login-page [ {0} ] value does define the location in the web application [ {1} ] where the page can be used for login page can be found.",
			           new Object[] {formLoginPage, descriptor.getName()}));
	        } else {
		    result.addErrorDetails(smh.getLocalString
			("tests.componentNameConstructor",
			"For [ {0} ]",
			new Object[] {compName.toString()}));
		    result.failed(smh.getLocalString
			          (getClass().getName() + ".failed",
			           "Error: The form-login-page [ {0} ] value does not define the location in the web application [ {1} ] where the page to be used for the login page can be found.",
			           new Object[] {formLoginPage, descriptor.getName()}));
	        }
	    } else {
		result.addNaDetails(smh.getLocalString
			("tests.componentNameConstructor",
			"For [ {0} ]",
			new Object[] {compName.toString()}));
	        result.notApplicable(smh.getLocalString
	    			 (getClass().getName() + ".notApplicable",
	    			  "There are no form-login-page name elements within this web archive [ {0} ]",
	    			  new Object[] {descriptor.getName()}));
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
			("tests.componentNameConstructor",
			"For [ {0} ]",
			new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no form-login-page name elements within this web archive [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}

	return result;
    }
}
