/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Set;

/**
 * Assertion
 *
 *  A stateful session bean should not be injected into a servlet.
 *
 * @author bshankar@sun.com
 */
public class StatefulSessionBeanInjection extends WebTest implements WebCheck  {
    
    final static String className = StatefulSessionBeanInjection.class.getName();
    
    public Result check(WebBundleDescriptor descriptor) {
        // initialize the result object
        Result result = getInitializedResult();
        addWarningDetails(result,
                getVerifierContext().getComponentNameConstructor());
        result.setStatus(Result.PASSED); //default status is PASSED
        
        Set<EjbReferenceDescriptor> s = descriptor.getEjbReferenceDescriptors();
        if (s == null) return result;
        
        for(EjbReferenceDescriptor ejbRefDesc : s) {
            EjbDescriptor ejbDescriptor = ejbRefDesc.getEjbDescriptor();
            if (ejbDescriptor instanceof EjbSessionDescriptor) { // instaceof returns false if ejbDescriptor=null.
                String stateType = ((EjbSessionDescriptor)ejbDescriptor).getSessionType();
                if(EjbSessionDescriptor.STATEFUL.equals(stateType)) {
                    Set<InjectionTarget> injectionTargets = ejbRefDesc.getInjectionTargets();
                    if(injectionTargets != null) {
                        for(InjectionTarget it : injectionTargets) {
                            String itClassName = it.getClassName();
                            result.warning(smh.getLocalString(className + ".warning",
                                    "Found a stateful session bean [ {0} ] injected into [ {1} ].",
                                    new Object[]{ejbDescriptor.getEjbClassName(), itClassName}));
                        }
                    }
                }
            }
        }
        return result;
    }
    
}
