/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 *  Must check for the existence of the tld file.
 *  @author     Arun Jain
 */
public class TaglibLocation extends Taglib implements WebCheck {
    

     /** 
     * .tld file exists test.
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        boolean passed = true;
        TagLibConfigurationDescriptor taglibDescriptor;
        String taglibLocation;  
        Enumeration taglibConfig = (new Vector()).elements();
        if (descriptor.getJspConfigDescriptor() != null) {
            taglibConfig = descriptor.getJspConfigDescriptor().getTagLibs();
        }

        if (taglibConfig.hasMoreElements()){
            while (taglibConfig.hasMoreElements()) {           
                // test all the Tag lib descriptors.
                taglibDescriptor =  (TagLibConfigurationDescriptor) taglibConfig.nextElement();
                taglibLocation = taglibDescriptor.getTagLibLocation();
                if(passed == false)
                    check(descriptor, taglibLocation, result);
                else
                    passed = check(descriptor, taglibLocation, result);         
            }
        } else {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
            result.notApplicable(smh.getLocalString
                                 (getClass().getName() + ".notApplicable",
                                  "There are no TagLibConfigurationDescriptors within the web archive [ {0} ]",
                                  new Object[] {descriptor.getName()}));
            result.setStatus(Result.NOT_APPLICABLE);       
            return result;
            
        } 
        
        if ( passed) {
            result.setStatus(Result.PASSED);       
        }  else {
            result.setStatus(Result.FAILED);
         }
        
        return result;
    }
}
