/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a class reference in the constant pool
 */

public class ConstClass extends ConstBasic {
  /* The tag associated with ConstClass entries */
  public static final int MyTag = CONSTANTClass;

  /* The name of the class being referred to */
  private ConstUtf8 theClassName;

  /* The index of name of the class being referred to
   *  - used while reading from a class file */
  private int theClassNameIndex;

  /* public accessors */

  /**
   * Return the tag for this constant
   */
  public int tag () { return MyTag; }

  /**
   * Return the class name
   */
  public ConstUtf8 className() {
    return theClassName;
  }

  /**
   * Return the class name in simple string form
   */
  public String asString() {
    return theClassName.asString();
  }

  /**
   * A printable representation 
   */
  public String toString () {
      return "CONSTANTClass(" + indexAsString() + "): " + //NOI18N
          "className(" + theClassName.toString() + ")";//NOI18N
  }

  /**
   * Change the class reference (not to be done lightly)
   */
  public void changeClass(ConstUtf8 newName) {
    theClassName = newName;
    theClassNameIndex = newName.getIndex();
  }

  /* package local methods */

  /**
   * Construct a ConstClass
   */
  public ConstClass (ConstUtf8 cname) {
    theClassName = cname;
  }

  ConstClass (int cname) {
    theClassNameIndex = cname;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeShort(theClassName.getIndex());
  }

  static ConstClass read (DataInputStream input) throws IOException {
    return new ConstClass (input.readUnsignedShort());
  }

  void resolve (ConstantPool p) {
    theClassName = (ConstUtf8) p.constantAt(theClassNameIndex);
  }
}

