/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a unicode string value in the constant pool
 */

/* 
 * Note: evidence suggests that this is no longer part of the java VM
 * spec.
 */

public class ConstUnicode extends ConstBasic {
  /* The tag associated with ConstClass entries */
  public static final int MyTag = CONSTANTUnicode;
 
  /* The unicode string of interest */
  private String stringValue;

  /* public accessors */

  /**
   * The tag of this constant entry
   */
  public int tag () { return MyTag; }

  /**
   * return the value associated with the entry
   */
  public String asString() {
    return stringValue;
  }

  /**
   * A printable representation
   */
  public String toString () {
      return "CONSTANTUnicode(" + indexAsString() + "): " + stringValue;//NOI18N
  }

  /* package local methods */

  ConstUnicode (String s) {
    stringValue = s;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeBytes(stringValue);
  }

  static ConstUnicode read (DataInputStream input) throws IOException {
    int count = input.readShort(); // Is this chars or bytes?
    StringBuffer b = new StringBuffer();
    for (int i=0; i < count; i++) { 
      b.append(input.readChar());
    }
    return new ConstUnicode (b.toString());
  }

  void resolve (ConstantPool p) {
  }
}


