/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * ConstantValueAttribute represents a constant value attribute 
 * in a class file.  These attributes are used as initialization
 * values for static fields.
 */

public class ConstantValueAttribute extends ClassAttribute {
  /* The expected name of this attribute */
    public static final String expectedAttrName = "ConstantValue";//NOI18N

  /* The value */
  private ConstValue constantValue;

  /* public accessors */

  public ConstValue value() {
    return constantValue;
  }

  /** 
   * Construct a constant value attribute
   */
  public ConstantValueAttribute(ConstUtf8 attrName, ConstValue value) {
    super(attrName);
    constantValue = value;
  }

  /* package local methods */

  static ConstantValueAttribute read (ConstUtf8 attrName,
                             DataInputStream data, ConstantPool pool)
    throws IOException {
    int index = 0;
    index = data.readUnsignedShort();

    return new ConstantValueAttribute(attrName,
                 (ConstValue) pool.constantAt(index));
  }

  void write(DataOutputStream out) throws IOException {
    out.writeShort(attrName().getIndex());
    out.writeInt(2);
    out.writeShort(constantValue.getIndex());
  }

  void print(PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println("ConstantValue: " + constantValue.toString());//NOI18N
  }
}

