/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DDLTemplateFormatter.java
 *
 * Created on Jan 14, 2003
 */

package com.sun.jdo.spi.persistence.generator.database;

import java.text.MessageFormat;

/*
 * This class provides methods that format strings containing DDL.  The
 * resulting strings are dependent on a particular MappingPolicy.
 *
 * @author Jie Leng, Dave Bristor
 */
// XXX FIXME This will not work in the unlikely event that 2 apps are being
// deployed at once.  It has reset invoked in DDLGenerator.generateDDL, but
// if another generateDDL can happen simultaneously, we're in trouble.
class DDLTemplateFormatter {
    /** Formatter for the start of "create table" DDL. */
    private static MessageFormat createTableStart = null; 

    /** Formatter for "add constraint" DDL. */
    private static MessageFormat alterTableAddConstraintStart = null; 

    /** Formatter for "drop constraing" DDL. */
    private static MessageFormat alterTableDropConstraint = null;

    /** Formatter for DDL for adding a PK constraint. */
    private static MessageFormat primaryKeyConstraint = null; 

    /** Formatter for DDL for adding an FK constraint. */
    private static MessageFormat foreignKeyConstraint = null; 

    /** Formatter for "drop table" DDL. */
    private static MessageFormat dropTable = null;

    
    /**
     * Prevent instantiation.
     */
    private DDLTemplateFormatter() {
    }

    /**
     * Resets MessageFormats for code generation as per policy.
     * @param mappingPolicy Policy that determines formatters provided by
     * this class.
     */
    static void reset(MappingPolicy mappingPolicy) {
        createTableStart = new MessageFormat(
                mappingPolicy.getCreateTableStart());

        alterTableAddConstraintStart = new MessageFormat(
                mappingPolicy.getAlterTableAddConstraintStart());

        alterTableDropConstraint = new MessageFormat(
                mappingPolicy.getAlterTableDropConstraint());

        primaryKeyConstraint = new MessageFormat(
                mappingPolicy.getPrimaryKeyConstraint());

        foreignKeyConstraint = new MessageFormat(
                mappingPolicy.getForeignKeyConstraint());

        dropTable = new MessageFormat(
                mappingPolicy.getDropTable());
    }

    
    /**
     * @returns A String formatted for the start of "create table" DDL.
     */
    static String formatCreateTable(Object o) {
        return createTableStart.format(o);
    }

    /**
     * @returns A String formatted for "add constraint" DDL.
     */
    static String formatAlterTableAddConstraint(Object o) {
        return alterTableAddConstraintStart.format(o);
    }

    /**
     * @returns A String formatted for "drop constraint" DDL.
     */
    static String formatAlterTableDropConstraint(Object o) {
        return alterTableDropConstraint.format(o);
    }

    /**
     * @returns A String formatted for DDL for adding a PK constraint.
     */
    static String formatPKConstraint(Object o) {
        return primaryKeyConstraint.format(o);
    }

    /**
     * @returns A String formatted for DDL for adding an FK constraint.
     */
    static String formatFKConstraint(Object o) {
        return foreignKeyConstraint.format(o);
    }

    /**
     * @returns A String formatted for "drop table" DDL.
     */
    static String formatDropTable(Object o) {
        return dropTable.format(o);
    }
}
