/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.spi.persistence.generator.database;

/** 
 * This interface defines string constants used by the database generation.
 *
 * @author Jie Leng, Dave Bristor
 */
// XXX Rename this class to "Constants"
interface DatabaseGenerationConstants {

    /** Separator between property name bases and indicators. */
    static final char DOT = '.';

    /** Indicator that property is for a maximum length. */
    static final String INDICATOR_MAXIMUM_LENGTH = "maximum-length"; //NOI18N

    /**
     * (Partial) indicator that property is for attributes of SQL.  The prefix
     * is recognized by alone by itself in MappingFile, and is used by other
     * DatabaseGenerationConstants.
     */
    static final String INDICATOR_JDBC_PREFIX = "jdbc"; //NOI18N

    /** Indicator that property designates the length of mapped SQL type. */
    static final String INDICATOR_JDBC_LENGTH =
        INDICATOR_JDBC_PREFIX + "-" + INDICATOR_MAXIMUM_LENGTH; //NOI18N

    /** Indicator that property designates the nullability of mapped SQL type. */
    static final String INDICATOR_JDBC_NULLABLE =
        INDICATOR_JDBC_PREFIX + "-nullable"; //NOI18N

    /** Indicator that property designates the precision of mapped SQL type. */
    static final String INDICATOR_JDBC_PRECISION =
        INDICATOR_JDBC_PREFIX + "-precision"; //NOI18N

    /** Indicator that property designates the scale of mapped SQL type. */
    static final String INDICATOR_JDBC_SCALE =
        INDICATOR_JDBC_PREFIX + "-scale"; //NOI18N

    /** Indicator that property designates the type of a mapped SQL type. */
    static final String INDICATOR_JDBC_TYPE =
        INDICATOR_JDBC_PREFIX + "-type"; //NOI18N
}
