/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DatabaseOutputStream.java
 *
 * Created on Jan 14, 2003
 */


package com.sun.jdo.spi.persistence.generator.database;

import java.io.*;
import java.sql.*;
import java.util.ResourceBundle;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;


/*
 * Represents a database connection as an output stream.
 *
 * @author Jie Leng 
 */
public class DatabaseOutputStream extends OutputStream {
     /** The logger */
    private static final Logger logger =
            LogHelperDatabaseGenerator.getLogger();

    /** I18N message handler */
    private final static ResourceBundle messages =
            I18NHelper.loadBundle(DatabaseOutputStream.class);

    /** Connection to the database. */
    // XXX FIXME S/b final; make it so if we can get rid of setConnection.
    private Connection conn_ = null;

    // XXX FIXME Assert conn != null and directly set the value of conn;
    // remove setConnection (below)
    public DatabaseOutputStream(Connection conn) {
        super();
        setConnection(conn);
    }

    // XXX FIXME I think this is not needed.
    public DatabaseOutputStream() {
        super();
    }

    /**
     * Closes the database connection.
     */
    public void close() {
        try {
            // XXX test is not necessary once we assert not null in constructor
            if (conn_ != null) {
                conn_.commit();
                // Close the connection
                conn_.close();
            }

        } catch (SQLException e) {
        if (logger.isLoggable(Logger.FINE))
            logger.fine("Exception in cleanup", e); // NOI18N
        }
    }

    /**
     * Commits the database connection.
     */
    public void flush() {
        try {
            // XXX test is not necessary once we assert not null in constructor
            if (conn_ != null) {
                conn_.commit();
            }
        } catch (SQLException e) {
            if (logger.isLoggable(Logger.FINE))
               logger.fine("Exception in cleanup", e); // NOI18N
        }
    }

    /**
     * This method is not supported in DatabaseOutputStream because it
     * doesn't make sense to write a single int to a database stream.  So
     * always throws UnsupportedOperationException.
     * @throws UnsupportedOperationException
     */ 
    public void write(int b) {
        throw new UnsupportedOperationException(); 
    }

    /**
     * Executes the given statement in the database.
     * @param stmt SQL to be executed
     * @throws SQLException Thrown if there is a problem preparing stmt as a
     * statement, or in executing it.
     */
    public void write(String stmt) throws SQLException {
        PreparedStatement pstmt = conn_.prepareStatement(stmt);
        pstmt.execute();
    }

    // XXX FIXME Is this really necessary?  Delete if possible.
    public void setConnection(Connection conn) {
        conn_ = conn;
    }
}
