/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EJBInfoHelper.java
 *
 * Created on October 15, 2004, 12:51 PM
 */

package com.sun.jdo.api.persistence.mapping.ejb;

import java.util.Collection;

import org.netbeans.modules.dbschema.SchemaElement;

import com.sun.jdo.api.persistence.model.Model;

/** This is an interface which represents information found in the 
 * ejb-jar.xml descriptor and provides a variety of other information
 * and helper objects needed to do mapping and generating of ejb related 
 * things in persistence.
 *
 * @author Rochelle Raccah
 */
public interface EJBInfoHelper
{
	/** Gets the name of the ejb jar.
	 * @return the name of the ejb jar
	 */
	public String getEjbJarDisplayName ();

	/** Gets a collection of names of schemas defined in this
	 * ejb jar.
	 * @return a collection schema names
	 */
	public Collection getAvailableSchemaNames ();

	/** Gets the name to use for schema generation.  An example might be
	 * a combo of app name, module name, etc.
	 * @return the name to use for schema generation
	 */
	public String getSchemaNameToGenerate ();

	/** Gets the schema with the specified name, loading it if necessary.
	 * @param schemaName the name of the schema to be loaded
	 * @return the schema object
	 */
	public SchemaElement getSchema (String schemaName);

	/** Gets a collection of names of cmp entity beans defined in this
	 * ejb jar.
	 * @return a collection cmp ejb names
	 */
	public Collection getEjbNames ();

	/** Gets a collection of names of cmp fields and cmr fields defined in 
	 * this ejb jar for the specified ejb.
	 * @param ejbName the name of the ejb for which a list of fields 
	 * will be created
	 * @return a collection cmp and cmr field names
	 */
	public Collection getFieldsForEjb (String ejbName);

	/** Gets a collection of names of cmr fields defined in 
	 * this ejb jar for the specified ejb.
	 * @param ejbName the name of the ejb for which a list of cmr fields 
	 * will be created
	 * @return a collection cmr field names
	 */
	public Collection getRelationshipsForEjb (String ejbName);

	/** Gets the class loader which corresponds to this ejb jar.
	 * Implementations can return <code>null</code> if this is not 
	 * relevant.
	 * @return the class loader which corresponds to this ejb jar
	 */
	public ClassLoader getClassLoader ();

	/** Gets the AbstractNameMapper object to use for this helper.
	 * @return the name mapper object
	 */
	public AbstractNameMapper getNameMapper ();

	/** Creates and returns an instance of the AbstractNameMapper object to 
	 * use for generation of unique names with this helper.  Unique names 
	 * usually means that the mapper doesn't use the same jdo and ejb names.
	 * Note that this method is a factory-like method which creates a new 
	 * instance so the caller can make modifications to it as necessary.
	 * @return the name mapper object
	 */
	public AbstractNameMapper createUniqueNameMapper ();

	/** Creates and returns an instance of the ConversionHelper object to 
	 * use for this helper.  Note that this method is a factory-like method
	 * which creates a new instance so the caller can make modifications to 
	 * it as necessary.
	 * @return the conversion helper object
	 */
	public ConversionHelper createConversionHelper ();

	/** Gets the Model object to use for this helper.
	 * @return the model object
	 */
	public Model getModel ();
}
