/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConcurrencyGroupElement.java
 *
 * Created on February 29, 2000, 5:21 PM
 */

package com.sun.jdo.api.persistence.model.jdo;

/** 
 *
 * @author raccah
 * @version %I%
 */
public class ConcurrencyGroupElement extends FieldGroupElement
{
	/** Create new ConcurrencyGroupElement with no implementation. 
	 * This constructor should only be used for cloning and archiving.
	 */
	public ConcurrencyGroupElement ()
	{
		this(null, null);
	}

	/** Create new ConcurrencyGroupElement with the provided implementation. 
	 * The implementation is responsible for storing all properties of the 
	 * object.
	 * @param impl the implementation to use
	 * @param declaringClass the class to attach to
	 */
	public ConcurrencyGroupElement (ConcurrencyGroupElement.Impl impl,
		PersistenceClassElement declaringClass)
	{
		super(impl, declaringClass);
	}

	/** @return implemetation factory for this concurrency group
	 */
	final Impl getConcurrencyGroupImpl () { return (Impl)getImpl(); }

	/** Pluggable implementation of concurrency group elements.
	 * @see ConcurrencyGroupElement
	 */
	public interface Impl extends FieldGroupElement.Impl { }
}

