/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore.database;

import java.util.List;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.DatabaseMetaData;

import com.sun.jdo.api.persistence.support.SpecialDBOperation;

/**
 * BaseSpecialDBOperation is the base class for all classes implementing
 * DBSpecificOperation.
 * @author Shing Wai Chan
 */
public class BaseSpecialDBOperation implements SpecialDBOperation {
    /**
     * @inheritDoc
     */
    public void initialize(DatabaseMetaData metaData,
        String identifier) throws SQLException {
    }

    /**
     * @inheritDoc
     */
    public void defineColumnTypeForResult(
        PreparedStatement ps, List columns) throws SQLException {
    }

    /**
     * @inheritDoc
     */
    public void bindFixedCharColumn(PreparedStatement ps,
         int index, String strVal, int length) throws SQLException {
         ps.setString(index, strVal);
    }

}
