/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ReferenceKeyDesc.java
 *
 * Create on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.model;



/**
 * This class encapsulate the association of two KeyDescs.
 * It can be used to represent the inheritance key or 
 * the reference key between primary and secondary tables.
 */
public class ReferenceKeyDesc extends Object {
    private KeyDesc referencingKey;

    private KeyDesc referencedKey;

    private TableDesc table;

	public ReferenceKeyDesc(TableDesc table, 
							KeyDesc referencingKey,
							KeyDesc referencedKey) {
		this.referencingKey = referencingKey;
		this.referencedKey = referencedKey;
		this.table = table;
	}

	public KeyDesc getReferencingKey() {
		return referencingKey;
	}

	public KeyDesc getReferencedKey() {
		return referencedKey;
	}

	public TableDesc getTableDesc() {
		return table;
	}
}
