/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FloatingPointType.java
 *
 * Created on April 5, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

/** 
 * This class represents the types float and double.
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class FloatingPointType
    extends NumericType
{
    /**
     *
     */
    public FloatingPointType(String name, Class clazz, int enumType)
    {
        super(name, clazz, enumType);
    }

    /**
     * Converts the specified value into a value of this numeric type.
     * E.g. an Integer is converted into a Double, if this represents 
     * the numeric type double.
     * @param value value to be converted
     * @return converted value
     */
    public Number getValue(Number value)
    {
        Number ret = null;

        if (value == null)
            ret = null;
        else if ("double".equals(getName()))
            ret = new Double(value.doubleValue());
        else if ("float".equals(getName()))
            ret = new Float(value.floatValue());

        return ret;
    }

    /**
     * Returns -value. 
     * @param value value to be negated
     * @return -value
     */
    public Number negate(Number value)
    {
        Number ret = null;

        if (value == null)
            ret = null;
        else if ("double".equals(getName()))
            ret = new Double(-value.doubleValue());
        else if ("float".equals(getName()))
            ret = new Float(-value.floatValue());

        return ret;
    }
}
