/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * NumericWrapperClassType.java
 *
 * Created on April 14, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

/** 
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class NumericWrapperClassType
    extends WrapperClassType
    implements NumberType
{
    /**
     *
     */
    public NumericWrapperClassType(String name, Class clazz, int enumType, 
                                   PrimitiveType primitiveType, TypeTable typetab)
    {
        super(name, clazz, enumType, primitiveType, typetab);
    }
    
    /**
     * A numeric wrapper class type defines an ordering.
     */
    public boolean isOrderable()
    {
        return true;
    }

    /**
     * Converts the specified value into a value of this numeric type.
     * E.g. an Integer is converted into a Double, if this represents 
     * the numeric type double.
     * @param value value to be converted
     * @return converted value
     */
    public Number getValue(Number value)
    {
        return ((NumericType)primitiveType).getValue(value);
    }

    /**
     * Returns -value. 
     * @param value value to be negated
     * @return -value
     */
    public Number negate(Number value)
    {
        return ((NumericType)primitiveType).negate(value);
    }
}
