/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ColumnRef.java
 *
 * Create on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import org.netbeans.modules.dbschema.ColumnElement;
import com.sun.jdo.api.persistence.support.FieldMapping;

/**
 */
public class ColumnRef extends Object implements FieldMapping {
	//
	// actual ColumnElement from the dbmodel
	//
    private ColumnElement columnElement;

	//
	// the table this column belongs to
	//
    private QueryTable table;

	//
	// input value for this column for update statements.
        // This field contains LocalFieldDesc for the corresponding field when
        // an UpdateStatement using batching uses this field.
	//
    private Object value;

	//
	// the position of this column in the SQL statement
	//
	private int index;

	//
	// the name of this column
	//
	private String name;

	public ColumnRef(ColumnElement columnElement,
					 QueryTable table) {
		this.columnElement = columnElement;
		name = columnElement.getName().getName();
		this.table = table;
	}

	public ColumnRef(ColumnElement columnElement,
					 Object value) {
		this.columnElement = columnElement;
		name = columnElement.getName().getName();
		this.value = value;
	}

	/** Return the actual ColumnElement associated with this column.
     *  @return the ColumnElement associated with this
	 */
	public ColumnElement getColumnElement() {
		return columnElement;
	}

	/** Return the position of this column in the SQL statement.
	 *  @return the position of this column in the SQL statement
	 */
	public int getIndex() {
		return index;
	}

	/** Set the position of this column in the SQL statement.
	 *  @param value - the new position
     */
	public void setIndex(int value) {
		this.index = value;
	}

	/** Return the input value for this column.
     *  @return the input value for this column
	 */
	public Object getValue() {
		return value;
	}

	/** Return the QueryTable associated with this column. 
	 *  @return the QueryTable associated with this column. 
	 */
	public QueryTable getQueryTable() {
		return table;
	}

	/** Return the name of this column.
     *  @return the name of this column.
	 */
	public String getName() {
		return name;
	}

     //---- implementing FieldMapping ------------------------------//
     /**
      * This method return int corresponding to java.sql.Types.
      */
     public int getColumnType() {
         return columnElement.getType();
     }

     /**
      * This method return the name of the column.
      */
     public String getColumnName() {
         return name;
     }

     /**
      * This method return the length of the column and -1 if unknown.
      */
     public int getColumnLength() {
         Integer len = columnElement.getLength();
         return (len != null) ? len.intValue(): -1;
     }

     //---- end of implementing FieldMapping -----------------------//
}
