/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 *  PersistentDirty.java    March 10, 2000    Steffi Rauschenbach
 */

package com.sun.jdo.spi.persistence.support.sqlstore.state;

import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;

public class PersistentDirty extends LifeCycleState {
    public PersistentDirty() {
        // these flags are set only in the constructor
        // and shouldn't be changed afterwards
        // (cannot make them final since they are declared in superclass
        // but their values are specific to subclasses)
        isPersistent = true;
        isPersistentInDataStore = true;
        isTransactional = true;
        isDirty = true;
        isNew = false;
        isDeleted = false;
        isNavigable = true;
        isRefreshable = true;
        isBeforeImageUpdatable = true;
        needsRegister = true;
        needsReload = false;
        needsRestoreOnRollback = false;
        updateAction = ActionDesc.LOG_UPDATE;

        stateType = P_DIRTY;
    }

    public LifeCycleState transitionDeletePersistent() {
        return changeState(P_DELETED);
    }

    public LifeCycleState transitionRefreshPersistent() {
        return changeState(P_CLEAN);
    }

    public LifeCycleState transitionCommit(boolean retainValues) {
        if (retainValues) {
            return changeState(P_NON_TX);
        } else {
            return changeState(HOLLOW);
        }
    }

    public LifeCycleState transitionRollback(boolean retainValues) {
        if (retainValues) {
            return changeState(P_NON_TX);
        } else {
            return changeState(HOLLOW);
        }
    }

    public LifeCycleState transitionRefresh() {
        return changeState(P_CLEAN);
    }
}









