/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/** SampleBeanScenario.java
 */

package sample;

import javax.naming.*;
import javax.resource.cci.*;
import java.util.Iterator;
import javax.resource.ResourceException;

public class SampleBeanScenario {

  public void method() {
    
    try {
      Context nc = new InitialContext();

      // JNDI lookup for ConnectionFactory
      ConnectionFactory cf = (ConnectionFactory)nc.lookup(
				 "java:comp/env/eis/ConnectionFactory");
      Connection cx = cf.getConnection();

      // Create an Interaction 
      Interaction ix = cx.createInteraction();

      // Create an InteractionSpec and set properties
      InteractionSpecImpl ixSpec = new InteractionSpecImpl();
      ixSpec.setFunctionName("<NAME OF FUNCTION>");
      ixSpec.setInteractionVerb(InteractionSpec.SYNC_SEND_RECEIVE);

      // Get a RecordFactory to create input/output generic Records
      RecordFactory rf = cf.getRecordFactory();
      
      // Create an input MappedRecord
      MappedRecord input = rf.createMappedRecord("Name of Record");
      input.put("<key: element1>", new String("<VALUE1>"));
      input.put("<key: element2>", new String("<VALUE2>")); 

      // Create an output custom Record
      EmployeeRecord employee = new EmployeeRecordImpl();

      // Execute the Interaction
      ix.execute(ixSpec, input, employee);

      // Check the EmployeeRecord
      System.out.println( employee.getName() + ":" +
			  employee.getId());
    }
    catch (NamingException ne) {
      return;
    }
     catch (ResourceException e) {
      return;
    }    
  }


  public static void main(String[] args) {
  }

}
