/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth;

import javax.xml.soap.*;

/**
  * SOAP authentication parameter.
  *
  * <p> An instance of SOAPAuthParam may be created with a null response object
  * (for example during a call to
  * <code>ServerAuthContext.validateRequest</code>).
  * If so, a response object may be created as necessary (by modules),
  * and set into the SOAPAuthParam via the <code>setResponse</code> method.
  *
  * <p> An instance of SOAPAuthParam may also be created with a null
  * request object (for example during a call to
  * <code>ServerAuthContext.secureResponse</code>).
  *
  * @version 1.12, 06/08/04
  */
public class SOAPAuthParam implements AuthParam {

     private SOAPMessage request;
     private SOAPMessage response;

     /**
      * Create a SOAPAuthParam.
      *
      * @param request the SOAP request object, which may be null.
      * @param response the SOAP response object, which may be null.
      */
     public SOAPAuthParam(SOAPMessage request, SOAPMessage response) {
         this.request = request;
         this.response = response;
     }

     /**
      * Return the SOAP request object.
      *
      * @return the SOAP request object, which may be null.
      */
     public SOAPMessage getRequest() {
         return request;
     }

     /**
      * Return the SOAP response object.
      *
      * @return the SOAP response object, which may be null.
      */
     public SOAPMessage getResponse() {
         return response;
     }

     /**
      * Set the SOAP response object.
      *
      * <p> If a response has already been set (it is non-null),
      * this method does nothing.  The original response is not overwritten.
      *
      * @param response the SOAP response object.
      */
     public void setResponse(SOAPMessage response) {
         if (this.response == null) {
             this.response = response;
         }
     }
}
