/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth.callback;

import java.math.BigInteger;
import java.security.Principal;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;

/**
 * Callback for private key and corresponding certificate chain.
 *
 * @version %I%, %G%
 */
public class SecretKeyCallback implements Callback {

    private Request request;
    private SecretKey key;

    /**
     * Marker interface for private key request types.
     */
    public static interface Request { };

    /**
     * Request type for secret keys that are identified via an alias.
     */
    public static class AliasRequest implements Request {
	private String alias;

	/**
	 * Construct an AliasRequest with an alias.
	 *
	 * <p> The alias is used to directly identify the secret key
	 * to be returned.
	 *
	 * <p> If the alias is null,
	 * the handler of the callback relies on its own default.
	 *
	 * @param alias name identifier for the secret key, or null.
	 */
	public AliasRequest(String alias) {
	    this.alias = alias;
	}

	/**
	 * Get the alias.
	 *
	 * @return the alias, or null.
	 */
	public String getAlias() {
	    return alias;
	}
    }

    /**
     * Constructs this SecretKeyCallback with a secret key Request object.
     *
     * <p> The <i>request</i> object identifies the secret key
     * to be returned.
     *
     * If the alias is null, the handler of the callback
     * relies on its own default.
     *
     * @param request request object identifying the secret key, or null.
     */
    public SecretKeyCallback(Request request) {
	this.request = request;
    }

    /**
     * Get the Request object which identifies the secret key to be returned.
     *
     * @return the Request object which identifies the private key
     *		to be returned, or null.  If null, the handler of the callback
     *		relies on its own deafult.
     */
    public Request getRequest() {
	return request;
    }

    /**
     * Set the requested secret key.
     *
     * @param key the secret key, or null if no key was found.
     */
    public void setKey(SecretKey key) {
	this.key = key;
    }

    /**
     * Get the requested secret key.
     *
     * @return the secret key, or null if no key was found.
     */
    public SecretKey getKey() {
	return key;
    }
}
