/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package javax.enterprise.deploy.shared;

/**
 * Class StateTypes defines enumeration values for the 
 * DeploymentStatus object.
 *
 * @author  rsearls
 */
public class StateType 
{
	private int value; // This enumeration value's int value

	/**
	 * The action operation is running normally.
	 */
    public static final StateType RUNNING = new StateType(0);
	/**
	 * The action operation has completed normally.
	 */
    public static final StateType COMPLETED = new StateType(1);
	/**
	 * The action operation has failed.
	 */
    public static final StateType FAILED = new StateType(2);
	/**
	 * The DeploymentManager is running in discommected mode.
	 */
    public static final StateType RELEASED = new StateType(3);


	private static final String[] stringTable = {
	"running",
	"completed",
	"failed",
    "released",
	};

	private static final StateType[] enumValueTable = {
	RUNNING,
	COMPLETED,
	FAILED,
    RELEASED,
	};
    
    /**
     * Construct a new enumeration value with the given integer value.
     *
     * @param  value  Integer value.
     */
    protected StateType(int value) 
    {   this.value = value;
    }

    /**
     * Returns this enumeration value's integer value.
     * @return the value
     */
    public int getValue()
    {   return value;
    }
       
	/**
	 * Returns the string table for class StateType
	 */
	protected String[] getStringTable()
	{
		return stringTable;
	}

	/**
	 * Returns the enumeration value table for class StateType
	 */
	protected StateType[] getEnumValueTable()
	{
		return enumValueTable;
	}

    /**
     * Return an object of the specified value.
     * @param value a designator for the object.
     */
    public static StateType getStateType(int value)
    {   return enumValueTable[value];
    }

    /**
     * Return the string name of this StateType or the
     * integer value if outside the bounds of the table
     */
    public String toString()
    {
        String[] strTable = getStringTable();
        int index = value - getOffset();
        if (strTable != null && index >= 0 && index < strTable.length)
            return strTable[index];
        else
            return Integer.toString (value);
    }

    /**
     * Returns the lowest integer value used by this enumeration value's
     * enumeration class.
     * <P>
     * The default implementation returns 0.
     * @return the offset of the lowest enumeration value.
     */
    protected int getOffset()
    {   return 0;
    }
}
