/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.config;

/**
 * Cache type persistence property values.
 * 
 * 
 * JPA persistence property Usage:
 * 
 * for all entities append DEFAULT suffix to CACHE_TYPE_ prefix:
 * properties.add(TopLinkProperties.CACHE_TYPE_DEFAULT, CacheType.Weak);
 * 
 * for a single entity append either entity name or a full class name to CACHE_TYPE_ prefix:
 * properties.add(TopLinkProperties.EmployeeEntity, CacheType.Weak);
 * properties.add(TopLinkProperties.my.test.Employee, CacheType.Weak);
 * 
 * Values are case-insensitive.
 * "" could be used instead of default value CacheType.DEFAULT.
 * 
 * @see TopLinkProperties
 */
public class CacheType {
    public static final String  Weak = "Weak";
    public static final String  SoftWeak = "SoftWeak";
    public static final String  HardWeak = "HardWeak";
    public static final String  Full = "Full";
    public static final String  NONE = "NONE";
 
    public static final String DEFAULT = SoftWeak;
}
