/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.ejb.cmp3;

import oracle.toplink.essentials.sessions.*;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.threetier.ServerSession;

/**
 * <p>
 * <b>Purpose</b>: Defines the Interface for TopLink extensions to the EntityManager
 * <p>
 * @see javax.persistence.EntityManager
 */
/*
 * @author Gordon Yorke
 */

public interface EntityManager extends javax.persistence.EntityManager {

	/**
	 * This method returns the current session to the requestor.  The current session
	 * will be a the active UnitOfWork within a transaction and will be a 'scrap'
	 * UnitOfWork outside of a transaction.  The caller is conserned about the results
	 * then the getSession() or getUnitOfWork() API should be called.
	 */
    public Session getActiveSession();
    
    /**
     * Return the underlying server session
     */
    public ServerSession getServerSession();
    
    /**
     * This method will return the transactional UnitOfWork during the transaction and null
     * outside of the transaction.
     */
    public UnitOfWork getUnitOfWork();
    
    /**
     * This method will return a Session outside of a transaction and null within a transaction.
     */
    public Session getSession();
    
    /**
     * This method is used to create a query using a Toplink Expression and the return type.
     */
    public javax.persistence.Query createQuery(Expression expression, Class resultType);
    
    
}
