/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects;

import java.lang.reflect.Method;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

/**
 * An object to hold onto a valid EJB 3.0 decorated method.
 * 
 * @author Guy Pelletier
 * @since TopLink 10.1.3/EJB 3.0 Preview
 */
public class MetadataMethod extends MetadataAccessibleObject {
    protected Method m_setMethod;
    
    /**
     * INTERNAL:
     */
    public MetadataMethod(Method method) {
        super(method);
        
        m_setMethod = MetadataHelper.getSetMethod(method, method.getDeclaringClass());
        
        setName(method.getName());
        setAttributeName(MetadataHelper.getAttributeNameFromMethodName(method.getName()));
        setRelationType(MetadataHelper.getGenericReturnType(method));
    }
    
    /**
     * INTERNAL:
     */
    public String getSetMethodName() {
        return m_setMethod.getName();
    }
}
