/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables;

import javax.persistence.SecondaryTable;
import javax.persistence.PrimaryKeyJoinColumn;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumns;

/**
 * Object to hold onto a secondary table metadata in a TopLink database table.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class MetadataSecondaryTable extends MetadataTable  {
    private PrimaryKeyJoinColumn[] m_pkJoinColumns;
    protected MetadataPrimaryKeyJoinColumns m_primaryKeyJoinColumns;
    
    /**
     * INTERNAL:
     */
    public MetadataSecondaryTable() {
       m_primaryKeyJoinColumns = null; 
    }
    
    /**
     * INTERNAL:
     */
    public MetadataSecondaryTable(SecondaryTable secondaryTable) {
        this();
        
        if (secondaryTable != null) {
            m_name = secondaryTable.name();
            m_schema = secondaryTable.schema();
            m_catalog = secondaryTable.catalog();
            m_pkJoinColumns = secondaryTable.pkJoinColumns();
            
            processName();
            processUniqueConstraints(secondaryTable.uniqueConstraints());
        }
    }
    
    /**
     * INTERNAL:
     */
    public MetadataPrimaryKeyJoinColumns getPrimaryKeyJoinColumns(String sourceTableName) {
        if (m_primaryKeyJoinColumns == null) {
            processPrimaryKeyJoinColumns(sourceTableName);
        }
        
        return m_primaryKeyJoinColumns;
    }
    
    /**
     * INTERNAL: (Overridden in XMLSecondaryTable)
     */
    protected void processPrimaryKeyJoinColumns(String sourceTableName) {
        m_primaryKeyJoinColumns = new MetadataPrimaryKeyJoinColumns(m_pkJoinColumns, sourceTableName, m_databaseTable.getQualifiedName());
    }
}
