/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.BasicAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLClassAccessor;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLColumn;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLTableGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLSequenceGenerator;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.helper.DatabaseField;

import org.w3c.dom.Node;

/**
 * An XML extended basic accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLBasicAccessor extends BasicAccessor implements XMLAccessor {
    private Node m_node;
    private XMLHelper m_helper;
    
    /**
     * INTERNAL:
     */
    public XMLBasicAccessor(MetadataAccessibleObject accessibleObject, Node node, XMLClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        m_node = node;
        m_helper = classAccessor.getHelper();
    }

    /**
     * INTERNAL:
     */
    public String getCatalog() {
        return m_descriptor.getCatalog();
    }
    
    /**
     * INTERNAL: (OVERRIDE)
     * Build a metadata column. If one isn't found in XML then look for an
     * annotation.
     */
    protected MetadataColumn getColumn() {
        Node node = m_helper.getNode(m_node, XMLConstants.COLUMN);
        
        if (node != null) {
            return new XMLColumn(node, m_helper, this);
        } else {
            return super.getColumn();
        }
    }
    
    /**
     * INTERNAL:
     */
    public String getDocumentName() {
        return m_helper.getDocumentName();
    }
    
    /**
     * INTERNAL: (Overridden in XMLBasicAccessor)
     */
    public String getEnumeratedType() {
        if (hasEnumerated()) {
            return m_helper.getNodeTextValue(m_node, XMLConstants.ENUMERATED);
        } else {
            return super.getEnumeratedType();
        }
    }
    
    /**
     * INTERNAL:
     */
    public XMLHelper getHelper() {
        return m_helper;
    }
    
    /**
     * INTERNAL:
     */
    public String getSchema() {
        return m_descriptor.getSchema();
    }
    
    /**
     * INTERNAL:
     * Return the temporal type for this accessor. Assumes there is a temporal
     * node.
     */
    public String getTemporalType() {
        if (hasTemporal()) {
            return m_helper.getNodeTextValue(m_node, XMLConstants.TEMPORAL);
        } else {
            return super.getTemporalType();
        }
    }
    
    /**
     * INTERNAL: (OVERRIDE)
	 * Method to check if m_node has an enumerated sub-element.
     */
	public boolean hasEnumerated() {
        Node node = m_helper.getNode(m_node, XMLConstants.ENUMERATED);
        
        if (node == null) {
            return super.hasEnumerated();
        } else {
            return true;
        }
    }
    
    /**
     * INTERNAL: (OVERRIDE)
	 * Method to check if m_node has a temporal sub-element.
     */
	public boolean hasTemporal() {
        Node node = m_helper.getNode(m_node, XMLConstants.TEMPORAL);
        
        if (node == null) {
            return super.hasTemporal();
        } else {
            return true;
        }
    }
    
    /**
     * INTERNAL:
	 * Method to check if m_node represents a primary key.
	 */
	public boolean isId() {
        if (m_node.getLocalName().equals(XMLConstants.ID)) {
            return true;
        } else {
            return super.isId();   
        }
    }
    
    /**
     * INTERNAL: (OVERRIDE)
     * Return true if this accessor represents an BLOB/CLOB mapping, i.e. has a 
     * lob sub-element.
     */
	public boolean isLob() {
        Node node = m_helper.getNode(m_node, XMLConstants.LOB);
        
        if (node == null) {
            return super.isLob();
        } else {
            return true;
        }
    }
    
    /**
     * INTERNAL:
	 * Return true if this accessor represents an optimistic locking field.
     */
	public boolean isVersion() {
        Node node = m_helper.getNode(m_node, XMLConstants.VERSION);
        
        if (node == null) {
            return super.isVersion();
        } else {
            return true;
        }
    }
    
    /**
     * INTERNAL: (OVERRIDE)
     */
    protected void processGeneratedValue(DatabaseField field) {
        Node node = m_helper.getNode(m_node, XMLConstants.GENERATED_VALUE);

        if (node == null) {
            super.processGeneratedValue(field);
        } else {
            // Ask the common processor to process what we found.
            processGeneratedValue(new XMLGeneratedValue(node, m_helper), field);
        }
    }
    
    /**
     * INTERNAL: (OVERRIDE)
	 * Process this accessor's sequence-generator node into a common metadata 
     * sequence generator.
     */
    protected void processSequenceGenerator() {
        Node node = m_helper.getNode(m_node, XMLConstants.SEQUENCE_GENERATOR);
        
        if (node != null) {
            // Process the xml defined sequence generators first.
            processSequenceGenerator(new XMLSequenceGenerator(node, m_helper));
        }
        
        // Process the annotation defined sequence generators second.
        super.processSequenceGenerator();
    }
    
    /**
     * INTERNAL: (OVERRIDE)
	 * Process this accessor's table-generator node into a common metadata table 
     * generator.
     */
    protected void processTableGenerator() {
        Node node = m_helper.getNode(m_node, XMLConstants.TABLE_GENERATOR);
        
        if (node != null) {
            // Process the xml defined table generators first.
            processTableGenerator(new XMLTableGenerator(node, this));
        }
        
        // Process the annotation defined sequence generators second.
        super.processTableGenerator();
    }
}
