/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ManyToManyAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataJoinTable;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.tables.XMLJoinTable;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;

import org.w3c.dom.Node;

/**
 * A an extended many to many relationship accessor.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLManyToManyAccessor extends ManyToManyAccessor {    
    protected Node m_node;
    protected XMLHelper m_helper;
    
    /**
     * INTERNAL:
     */
    public XMLManyToManyAccessor(MetadataAccessibleObject accessibleObject, Node node, XMLClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        m_node = node;
        m_helper = classAccessor.getHelper();
        
        XMLAccessorHelper.setRelationshipAccessorData(this, m_node, m_helper);
    }
    
    /**
     * INTERNAL: (Override from CollectionAccessor)
     */
    public MetadataJoinTable getJoinTable() {
        Node node = m_helper.getNode(m_node, XMLConstants.JOIN_TABLE);
        
        if (node == null) {
            return super.getJoinTable();
        } else {
            return new XMLJoinTable(node, m_helper);
        }
    }
    
    /**
     * INTERNAL: (Override from CollectionAccessor)
     * Checks for a map-key node and returns its value if there is one. 
     * Otherwise, ask the parent to look for an annotation.
     */
    public String getMapKey() { 
        Node mapKeyNode = m_helper.getNode(m_node, XMLConstants.MAPKEY);
        String mapKeyValue = m_helper.getNodeValue(m_node, XMLConstants.MAPKEY);
        
        if (mapKeyNode == null) {
            return super.getMapKey();
        } else {
            return mapKeyValue;
        }
    }
    
    /**
     * INTERNAL: (Override from CollectionAccessor)
     * If the order value is not specified, "" is returned.
     */
    public String getOrderBy() {
        if (hasOrderBy()) {
            return m_helper.getNodeTextValue(m_node, XMLConstants.ORDER_BY);
        } else {
            return super.getOrderBy();
        }
    } 
    
    /**
     * INTERNAL: (Override from CollectionAccessor)
	 * Checks for an order-by node. If one isn't found, as the parent to look
     * for an annotation.
     */
	public boolean hasOrderBy() {
		Node orderByNode = m_helper.getNode(m_node, XMLConstants.ORDER_BY);
        
        if (orderByNode == null) {
            return super.hasOrderBy();
        } else {
            return true;
        }
	}
}
