/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.ejb.cmp3.xml.tables;

import org.w3c.dom.Node;

import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLConstants;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.tables.MetadataTable;

/**
 * Object to hold onto an XML table metadata in a TopLink database table.
 * 
 * @author Guy Pelletier
 * @since TopLink EJB 3.0 Reference Implementation
 */
public class XMLTable extends MetadataTable {
    /**
     * INTERNAL:
     */
    public XMLTable(Node node, XMLHelper helper) {
        m_name = helper.getNodeValue(node, XMLConstants.ATT_NAME);
        m_schema = helper.getNodeValue(node, XMLConstants.ATT_SCHEMA);
        m_catalog = helper.getNodeValue(node, XMLConstants.ATT_CATALOG);
        
        processName();
        XMLTableHelper.processUniqueConstraints(node, helper, m_databaseTable);
    }

    /**
     * INTERNAL:
     */
    public boolean loadedFromXML() {
        return true;
    }
}
