/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.identitymaps;

import java.lang.ref.*;
import java.util.Vector;

/**
 * <p><b>Purpose</b>: Container class for storing objects in an IdentityMap.
 * The weak cache key uses a weak reference to allow garbage collection of its object.
 * The cache key itself however will remain and thus should cleaned up every no and then.
 * <p><b>Responsibilities</b>:<ul>
 * <li> Hold key and object.
 * <li> Maintain and update the current writeLockValue.
 * </ul>
 * @since TOPLink/Java 1.0
 */
public class WeakCacheKey extends CacheKey {

    /** Reference is maintained weak to allow garbage collection */
    protected WeakReference reference;

    /**
     * Initialize the newly allocated instance of this class.
     * @param primaryKey contains values extracted from the object
     * @param writeLockValue is the write lock value, null if optimistic locking not being used for this object.
     * @param readTime the time TopLInk read the cache key
     */
    public WeakCacheKey(Vector primaryKey, Object object, Object writeLockValue, long readTime) {
        super(primaryKey, object, writeLockValue, readTime);
    }

    public Object getObject() {
        return getReference().get();
    }

    public WeakReference getReference() {
        return reference;
    }

    public void setObject(Object object) {
        setReference(new WeakReference(object));
    }

    protected void setReference(WeakReference reference) {
        this.reference = reference;
    }
}
