/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing;

/**
 * INTERNAL
 * <p><b>Purpose</b>: Represent a MOD
 * <p><b>Responsibilities</b>:<ul>
 * <li> Answer the correct expression for a MOD
 * <li> Maintain the parts of a MOD statement
 *
 * e.g.
 * SELECT ... FROM ... WHERE MOD(emp.salary, 2) > 1000
 * </ul>
 *    @author Jon Driscoll and Joel Lucuik
 *    @since TopLink 4.0
 */
import oracle.toplink.essentials.expressions.*;
import oracle.toplink.essentials.exceptions.EJBQLException;

public class ModNode extends ArithmeticFunctionNode {

    private Node denominator = null;

    /**
     * INTERNAL
     * Validate node and calculate its type.
     */
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (left != null) {
            left.validate(context);
            left.validateParameter(context, typeHelper.getIntType());

            Object type = left.getType();
            if (!typeHelper.isIntegralType(type))
                throw EJBQLException.invalidFunctionArgument("MOD", left.getAsString(), "integral type");
        }

        if (denominator != null) {
            denominator.validate(context);
            denominator.validateParameter(context, typeHelper.getIntType());

            Object denominatorType = denominator.getType();
            if (!typeHelper.isIntegralType(denominatorType))
                throw EJBQLException.invalidFunctionArgument("MOD", denominator.getAsString(), "integral type");
        }

        setType(typeHelper.getIntType());
    }
    
    /** */
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause;
        Integer i = new Integer(((LiteralNode)getDenominator()).getLiteral().toString());

        //        whereClause = ExpressionMath.mod(getLeft().generateExpression(context), i.intValue());
        if (getLeft().isLiteralNode()) {
            ExpressionBuilder builder = new ExpressionBuilder();
            Integer leftInt = new Integer(((IntegerLiteralNode)getLeft()).getLiteral().toString());
            whereClause = ExpressionMath.mod(builder.value(leftInt.intValue()), builder.value(i.intValue()));
        } else {
            whereClause = ExpressionMath.mod(getLeft().generateExpression(context), i.intValue());
        }
        return whereClause;
    }

    // Accessors
    public Node getDenominator() {
        return denominator;
    }

    public void setDenominator(Node denominator) {
        this.denominator = denominator;
    }
}
