/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2006, Oracle. All rights reserved.  
package oracle.toplink.essentials.internal.parsing.ejbql;

import persistence.antlr.TokenBuffer;
import persistence.antlr.TokenStreamException;
import persistence.antlr.TokenStream;
import persistence.antlr.RecognitionException;
import persistence.antlr.ParserSharedInputState;

//toplink imports
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.internal.parsing.ejbql.antlr273.EJBQLParserBuilder;

//java imports
import java.lang.reflect.Field;

/*****************************************************************
 * EJBQLParser is the superclass of all parsers generated
 * for the different versions of ANTLR
 *****************************************************************
 */
public class EJBQLParser extends EJBQLParserBase {

    public static String antlrVersion = "2.7.3";
    
    public EJBQLParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 3);
    }

    protected EJBQLParser(persistence.antlr.TokenBuffer tokenBuf, int k_) {
        super(tokenBuf, k_);
        initialize();
    }

    public EJBQLParser(ParserSharedInputState state, int k_) {
        super(state, k_);
    }

    protected EJBQLParser(TokenStream lexer, int k) {
        super(lexer, k);
    }

    public static String ANTLRVersion() throws Exception {
        return antlrVersion;
    }

    /**
     * INTERNAL
     * Build a parser for the passed ejbql string, depending on the version of the parser
     */
    public static EJBQLParser buildParserFor(String ejbqlString) throws EJBQLException {
        try {
            return EJBQLParserBuilder.buildParser(ejbqlString);
        } catch (Exception exception) {
            throw EJBQLException.generalParsingException(ejbqlString, exception);
        }
    }

    public void document() throws RecognitionException, TokenStreamException {
        //this is implemented in the generated subclass. This is to simplify EJBQLCall.	
    }
}
