/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.mappings;

import oracle.toplink.essentials.internal.queryframework.*;

/**
 * Interface used by clients to interact
 * with the assorted mappings that use <code>ContainerPolicy</code>.
 *
 * @see oracle.toplink.essentials.internal.queryframework.ContainerPolicy
 *
 * @author Big Country
 * @since TOPLink/Java 4.0
 */
public interface ContainerMapping {

    /**
     * PUBLIC:
     * Return the mapping's container policy.
     */
    ContainerPolicy getContainerPolicy();

    /**
     * PUBLIC:
     * Set the mapping's container policy.
     */
    void setContainerPolicy(ContainerPolicy containerPolicy);

    /**
     * PUBLIC:
     * Configure the mapping to use an instance of the specified container class
     * to hold the target objects.
     * <p>The container class must implement (directly or indirectly) the
     * <code>java.util.Collection</code> interface.
     */
    void useCollectionClass(Class concreteClass);

    /**
     * PUBLIC:
     * Configure the mapping to use an instance of the specified container class
     * to hold the target objects. The key used to index a value in the
     * <code>Map</code> is the value returned by a call to the specified
     * zero-argument method.
     * The method must be implemented by the class (or a superclass) of any
     * value to be inserted into the <code>Map</code>.
     * <p>The container class must implement (directly or indirectly) the
     * <code>java.util.Map</code> interface.
     * <p>To facilitate resolving the method, the mapping's referenceClass
     * must set before calling this method.
     */
    void useMapClass(Class concreteClass, String methodName);
}
