/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
// Copyright (c) 1998, 2005, Oracle. All rights reserved.  
package oracle.toplink.essentials.queryframework;

import oracle.toplink.essentials.internal.sessions.AbstractRecord;

/**
 * <p><b>Purpose</b>:
 * Abstract class for all modify queries.
 * Currently contains no behavoir.
 *
 * @author Yvon Lavoie
 * @since TOPLink/Java 1.0
 */
public abstract class ModifyQuery extends DatabaseQuery {
    protected AbstractRecord modifyRow;
    
    // needed to allow the user to force SQL to database when batch writing is used. bug:4104613
    protected boolean forceBatchStatementExecution = false;

    /**
     * INTERNAL:
     * Return the modify row
     */
    public AbstractRecord getModifyRow() {
        return modifyRow;
    }

    /**
     * PUBLIC:
     * Return if this is a modify query.
     */
    public boolean isModifyQuery() {
        return true;
    }

    /**
     * INTERNAL:
     * Set the modify row
     */
    public void setModifyRow(AbstractRecord row) {
        modifyRow = row;
    }
    
    /**
     * PUBLIC:
     * Allow setting this query to be the last statement added to a batch statement 
     * and ensure it is flushed on execution.  Setting to true will cause the batch
     * statement to be sent to the database.  Default setting of false causes the batch 
     * statement execution to be delayed to allow additional statements to
     * be added.  Setting to true reduces the efficiency of batch writting.  
     * 
     *  This has no effect if batch writing is not enabled.   
     */
     
    public void setForceBatchStatementExecution(boolean value) {
        this.forceBatchStatementExecution = value;
    }
    
    /**
     * PUBLIC:
     * Returns if this query has been set to flush on execution.
     * @see #setForceBatchStatementExecution(boolean)
     */
     
    public boolean forceBatchStatementExecution() {
        return forceBatchStatementExecution;
    }
}
