/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

//----------------------------------------------------------------------------
//
// Module:      StaticResource.java
//
// Description: Statically-registered Resource interface.
//
// Product:     com.sun.jts.CosTransactions
//
// Author:      Simon Holdsworth
//
// Date:        March, 1997
//
// Copyright (c):   1995-1997 IBM Corp.
//
//   The source code for this program is not published or otherwise divested
//   of its trade secrets, irrespective of what has been deposited with the
//   U.S. Copyright Office.
//
//   This software contains confidential and proprietary information of
//   IBM Corp.
//----------------------------------------------------------------------------

package com.sun.jts.CosTransactions;

import org.omg.CosTransactions.*;

/**
 * The StaticResource interface provides operations that allow an object to
 * be informed about changes in transaction associations with threads. The
 * operations are guaranteed to be invoked on the thread on which the
 * association is started or ended. This class is an abstract base class so
 * the behavior here is that which is expected from any subclass.
 *
 * @version 0.01
 *
 * @author Simon Holdsworth, IBM Corporation
 *
 * @see
 */

//----------------------------------------------------------------------------
// CHANGE HISTORY
//
// Version By     Change Description
//   0.01  SAJH   Initial implementation.
//----------------------------------------------------------------------------

public abstract class StaticResource {

    /**
     * Informs the object that an association has started.
     * <p>
     * That is, a thread association has begun on the calling thread for the
     * transaction represented by the given Coordinator object.
     * A flag is passed indicating whether this association is
     * as a result of a begin operation.
     *
     * @param coord  The transaction whose association is starting.
     * @param begin  Indicates a begin rather than a resume.
     *
     * @return
     *
     * @see
     */
    public abstract void startAssociation(Coordinator coord, boolean begin);

    /**
     * Informs the object that an association has ended.
     * <p>
     * That is, a thread association has ended on the calling thread for the
     * transaction represented by the given Coordinator object.
     * A flag is passed indicating whether this
     * association is as a result of the transaction completing.
     *
     * @param coord     The transaction whose association is starting.
     * @param complete  Indicates a commit/rollback rather than a suspend.
     *
     * @return
     *
     * @see
     */
    public abstract void endAssociation(Coordinator coord, boolean complete);

    /**
     * Registers the StaticResource object.
     * <p>
     * Until this method is called, the StaticResource object will not receive
     * calls to start/endAssociation.
     *
     * @param
     *
     * @return
     *
     * @see
     */
    protected void register() {
        CurrentTransaction.registerStatic(this);
    }
}
