/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.jts.jta;

import javax.naming.*;
import javax.naming.spi.*;

/**
 * Factory for producing the UserTransactionImpl objects.
 *
 * @author Ram Jeyaraman
 * @version 1.0 Feb 09, 1999
 */
public class UserTransactionFactory implements ObjectFactory {

	/**
     * @param obj Reference information that can be used in creating an object.
     * @param name of this object relative to nameCtx (optional).
     * @param nameCtx context relative to which the name parameter specified.
     * 	If null, name is relative to the default initial context.
	 * @param environment possibly null environment used in creating the object.
     *
     * @return object created; null if an object cannot be created.
     *
     * @exception java.lang.Exception if this object factory encountered
     * 	an exception while attempting to create an object.
     */
 	public Object getObjectInstance(Object refObj, Name name,
    	Context nameCtx, java.util.Hashtable env)
        throws Exception {

        if (refObj == null || !(refObj instanceof Reference))
        	return null;

        Reference ref = (Reference) refObj;

        if (ref.getClassName().
        	equals(UserTransactionImpl.class.getName())) {
            // create a new object
        	return new UserTransactionImpl();
        }

        return null;
    }
}
