/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: PwcServletStats.java,v 1.3 2005/12/25 04:27:29 tcfujii Exp $
 * $Date: 2005/12/25 04:27:29 $
 * $Revision: 1.3 $
 *
 */

package com.sun.enterprise.web.monitor;

import java.io.Serializable;

/** 
 * Monitoring interface for servlets.
 */
public interface PwcServletStats extends Serializable {

    /**
     * Gets the number of requests processed by the servlet.
     *
     * @return Number of processed requests
     */
    public int getRequestCount();
    
    /**
     * Gets the total execution time of the servlet's service method.
     *
     * @return Total execution time of the servlet's service method
     */
    public long getProcessingTimeMillis();

    /**
     * Gets the minimum request processing time of the servlet.
     *
     * @return Minimum request processing time
     */
    public long getMinTimeMillis();

    /**
     * Gets the maximum request processing time of the servlet.
     *
     * @return Maximum request processing time
     */
    public long getMaxTimeMillis();

    /** 
     * Gets the number of requests processed by the servlet that have resulted
     * in errors.
     *
     * @return Error count
     */
    public int getErrorCount();
    
}
