/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.web.monitor.impl;

import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.enterprise.web.logging.pwc.LogDomains;

class MonitorUtil {

    private static Logger _logger = LogDomains.getLogger(LogDomains.PWC_LOGGER);

    /*
     * Convenience method for logging messages that require parametric
     * replacement.
     */
    static void log(Level level,
                    String key,
                    Object[] params,
                    Throwable t) {

        String msg = _logger.getResourceBundle().getString(key);
        msg = MessageFormat.format(msg, params);
        _logger.log(level, msg, t);
    }
}
