/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */
package jsp2_1.examples.elresolver;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;

/**
 * ServletContextListener that installs the ColorELResolver,
 * enabling the use of ${Color}.
 * 
 * @author Mark Roth
 */
public class InstallColorListener 
    implements ServletContextListener
{
    public void contextInitialized(ServletContextEvent evt) {
        ServletContext context = evt.getServletContext();
        JspApplicationContext jspContext = 
            JspFactory.getDefaultFactory().getJspApplicationContext(context);
        jspContext.addELResolver(new ColorELResolver());
        
    }
    
    public void contextDestroyed(ServletContextEvent evt) {
    }
}
