/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LBInstance.java
 *
 * Created on June 21, 2004, 4:54 PM
 */

package com.sun.enterprise.tools.upgrade.cluster;

/**
 * This class represents instance element in loadbalancer.
 * 
 * @author  prakash
 */

import java.util.*;
import org.w3c.dom.Element;

public class LBInstance {
    
    private String name;
    private boolean enabled;
    private int disableTimeOut;
    private List listeners; // delimiter is space
    /** Creates a new instance of LBInstance */
    public LBInstance(Element ele) {
        this.name = ele.getAttribute("name");
        this.enabled = Boolean.getBoolean(ele.getAttribute("enabled"));
        this.disableTimeOut = Integer.getInteger(ele.getAttribute("disable-timeout-in-minutes")).intValue();
        listeners = new ArrayList();
        String listenersList = ele.getAttribute("listeners");
        StringTokenizer stk = new StringTokenizer(listenersList, " ");
        while(stk.hasMoreTokens()){
            listeners.add(stk.nextToken());
        }
    }
    public int getDisableTimeOut() {
        return disableTimeOut;
    }
        
    public boolean isEnabled() {
        return enabled;
    }
    
    public java.util.List getListeners() {
        return listeners;
    }
    public java.lang.String getName() {
        return name;
    }    
}
