/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * LBWebModule.java
 *
 * Created on June 21, 2004, 4:54 PM
 */

package com.sun.enterprise.tools.upgrade.cluster;

/**
 * This class represents web-module element in cluster
 *
 * @author  prakash
 */
import java.util.*;
import org.w3c.dom.Element;

public class LBWebModule {
    
    private String contextRoot;
    private boolean enabled;
    private int disabledTimeOut;
    /** Creates a new instance of LBWebModule */
    public LBWebModule(Element ele) {
        this.contextRoot = ele.getAttribute("context-root");
        this.enabled = Boolean.getBoolean(ele.getAttribute("enabled"));
        this.disabledTimeOut = Integer.getInteger(ele.getAttribute("disable-timeout-in-minutes")).intValue();        
    }
    public java.lang.String getContextRoot() {
        return contextRoot;
    }
    public int getDisabledTimeOut() {
        return disabledTimeOut;
    }
    public boolean isEnalbed() {
        return enabled;
    }    
}
