/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common;

import java.io.*;
import java.util.*;
import java.util.logging.*;
import com.sun.enterprise.tools.upgrade.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.certconversion.ProcessAdaptor;
import com.sun.enterprise.tools.upgrade.cluster.*;

/**
 *
 * author : Gautam Borah
 *
 */

public class CommonInfoModel{
    public static final String DOMAINS = "domains";
    public static final String CONFIG = "config";
    private static final String CERT_FILE_NAME = "keystore.jks";
    private static final String TRUSTED_KEY_STORE = "cacerts.jks";
    private static final String LICENSE_FILE = "LICENSE.txt";
    private static final String NUMBERSTRING = "0123456789";
    
    private StringManager stringManager = StringManager.getManager(LogService.UPGRADE_LOGGER);
    /**
     * Information specific to the certificate transformation module
     **/
    private static Logger logger=LogService.getLogger(LogService.UPGRADE_LOGGER);
    private String[] CERT_ALIASES;
    private String SOURCE_INSTALL_DIR;
    private boolean sourceInputAsDomainRoot;
    private boolean enlistDomain;
    private String TARGET_INSTALL_DIR;
    private String InstallConfig70;
    private boolean certificateConversionFlag=false;
    private List domainList;
    private List domainOptionList;
    private String targetDomainRoot;
    private String sourceDomainRoot="";
    private String currentDomain;
    private String currentSourceServerInstance = "";
    private String osName;
    
    // This is filled in only for EE
    private String currentCluster;
    
    // domainMapping stores domain name as key and domain path (..../domains/domain1) as value
    private Hashtable domainMapping;
    private Map domainNSSPwdMapping;
    private Map domainTargetNSSPwdMapping;
    private Map domainJKSPwdMapping;
    private Map domainJKSCAPwdMapping;
    private Map domainssPwdFileMapping;
    private Map domainTargetnssPwdFileMapping;
    private Map domainNameMapping;
    private String sourceVersionEdition;
    private String targetVersionEdition;
    
    // These are needed to create instances.
    private String adminUserName = null;
    private String adminPassword = null;
    private File passwordFile = null;
    private String passwordFilePath = null;
    private String masterPassword = "changeit";
    
    public CommonInfoModel(){
        domainList = new ArrayList();
        domainOptionList = new ArrayList();
        domainNSSPwdMapping = new HashMap();
        domainTargetNSSPwdMapping = new HashMap();
        domainJKSPwdMapping = new HashMap();
        domainJKSCAPwdMapping = new HashMap();
        domainssPwdFileMapping= new HashMap();
        domainTargetnssPwdFileMapping= new HashMap();
        domainNameMapping= new HashMap();
    }
    
    public void setTargetDomainRoot(String targetDomainsRoot) {
        if(targetDomainRoot != null && targetDomainRoot.equals(targetDomainsRoot))
            return;
        this.targetDomainRoot=targetDomainsRoot;
        try {
            String logPath = targetDomainRoot+File.separator+"upgrade.log";
            logger.info(stringManager.getString("common.log.redirect") + logPath);
            LogService.initialize(logPath);
        } catch(Exception e) {
            logger.warning(e.getLocalizedMessage());
        }
    }
    
    public String getTargetDomainRoot() {
        return targetDomainRoot;
    }
    
    public void setSourceDomainRoot(String sourceDomainRoot) {
        this.sourceDomainRoot=sourceDomainRoot;
    }
    
    public String getSourceDomainRoot() {
        return sourceDomainRoot;
    }
    public String getSourceDomainPath(){
        //String path = SOURCE_INSTALL_DIR + File.separator + DOMAINS + File.separator + currentDomain;
        return ((DomainInfo)getDomainMapping().get(currentDomain)).getDomainPath();
    }
    
    public String getSourceInstancePath(){
        //return getSourceDomainPath() + File.separator + getCurrentSourceInstance();
        return ((DomainInfo)this.getDomainMapping().get(this.getCurrentDomain())).getInstancePath(this.getCurrentSourceInstance());
    }
    
    public String getCurrentSourceInstance() {
        return currentSourceServerInstance;
    }
    
    public void setCurrentSourceInstance(String server) {
        currentSourceServerInstance = server;
    }
    
    public String getTargetConfig() {
        String config = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(currentDomain) + File.separator + CONFIG;
        return config;
    }
    
    public String getTargetJKSKeyStorePath(){
        String path = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(currentDomain) + File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }
    
    public String getTargetTrustedJKSKeyStorePath(){
        String path = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(currentDomain) + File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }
    
    public String getSourceJKSKeyStorePath(){
        String path = getSourceDomainPath() +  File.separator + CONFIG + File.separator + CERT_FILE_NAME;
        return path;
    }
    
    public String getSourceTrustedJKSKeyStorePath(){
        String path = getSourceDomainPath() +  File.separator + CONFIG + File.separator + TRUSTED_KEY_STORE;
        return path;
    }
    
    public String getDestinationDomainPath(){
        return getDestinationDomainPath(this.currentDomain);
    }
    public String getDestinationDomainPath(String domainName){
        String path = getTargetDomainRoot() + File.separator + (String)domainNameMapping.get(domainName);
        return path;
    }
    
    public void addDomainName(String domainName){
        domainList.add(domainName);
    }
    
    public List getDomainList(){
        return domainList;
    }
    
    public void addDomainOptionName(String domainName){
        domainOptionList.add(domainName);
    }
    
    public List getDomainOptionList(){
        return domainOptionList;
    }
    
    public String getCurrentDomain(){
        return currentDomain;
    }
    public void setCurrentDomain(String domainName){
        currentDomain=domainName;
    }
    
    public boolean getCertificateConversionFlag() {
        return certificateConversionFlag;
    }
    
    public void setCertificateConversionFlag(boolean flag){
        certificateConversionFlag=flag;
    }
    
    public String getSourceInstallDir() {
        return SOURCE_INSTALL_DIR;
    }
    
    public String getTargetInstallDir() {
        return TARGET_INSTALL_DIR;
    }
    
    public void setSourceInstallDir(String src) {
        SOURCE_INSTALL_DIR = src;
    }
    
    public void setTargetInstallDir(String tgt) {
        TARGET_INSTALL_DIR = tgt;
    }
    
    /**
     * Get the password for the NSS certificate database. If this is an NSS to NSS or NSS to JKS migration, the
     * String returned will be the source server password and getTargetCertDbPassword() will return
     * the target db password. If JKS to NSS, returns the target certificate db password.
     * @return String certpassword - the certificate password for the current domain and instance or null if the current
     *                               instance does not have a password, and should not be included in the cert migration.
     */
    public String getCertDbPassword() {
        Map instanceNSSPwdMap = (Map)domainNSSPwdMapping.get(currentDomain);
        return (String)instanceNSSPwdMap.get(currentSourceServerInstance);
    }
    
    public void setCertDbPassword(String pwd) {
        setCertDbPassword(currentDomain, currentSourceServerInstance, pwd);
    }
    
    public void setCertDbPassword(String domain, String pwd) {
        setCertDbPassword(domain, currentSourceServerInstance, pwd);
    }
    
    public void setCertDbPassword(String domain, String instance, String pwd) {
        Map instanceNssPwdMap = (Map)domainNSSPwdMapping.get(domain);
        if(instanceNssPwdMap == null) {
            instanceNssPwdMap = new HashMap();
        }
        instanceNssPwdMap.put(instance, pwd);
        domainNSSPwdMapping.put(domain,instanceNssPwdMap);
    }
    
    public String getTargetCertDbPassword() {
        return (String)domainTargetNSSPwdMapping.get(currentDomain);
    }
    
    public void setTargetCertDbPassword(String pwd) {
        domainTargetNSSPwdMapping.put(currentDomain,pwd);
        //NSS_DB_PASSWORD=pwd;
    }
    public void setTargetCertDbPassword(String domain, String pwd) {
        domainTargetNSSPwdMapping.put(domain,pwd);
    }
    
    public String[] getCertAliases() {
        return CERT_ALIASES;
    }
    
    public String getJksKeystorePassword() {
        return (String)domainJKSPwdMapping.get((String)domainNameMapping.get(currentDomain));
    }
    
    public void setJksKeystorePassword(String pwd) {
        domainJKSPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
        //JKS_DB_PASSWORD=pwd;
    }
    public void setJksKeystorePassword(String domain, String pwd) {
        domainJKSPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
    }
    
    public String getJksCAKeystorePassword() {
        return (String)domainJKSCAPwdMapping.get((String)domainNameMapping.get(currentDomain));
    }
    
    public void setJksCAKeystorePassword(String pwd) {
        domainJKSCAPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
    }
    
    public void setJksCAKeystorePassword(String domain, String pwd) {
        domainJKSCAPwdMapping.put((String)domainNameMapping.get(currentDomain),pwd);
    }
    
    public Hashtable getDomainMapping() {
        return domainMapping;
    }
    
    public void setDomainMapping(Hashtable domainMapping) {
        this.domainMapping = domainMapping;
    }
    
    public String getOSName() {
        return osName;
    }
    
    public void setOSName(String osName){
        this.osName = osName;
    }
    
    public String getNSSPwdFile() {
        return (String)domainssPwdFileMapping.get(currentDomain);
    }
    
    public void setNSSPwdFile(String pwdFile){
        domainTargetnssPwdFileMapping.put(currentDomain,pwdFile);
    }
    
    public String getTargetNSSPwdFile() {
        return (String)domainTargetnssPwdFileMapping.get(currentDomain);
    }
    
    public void setTargetNSSPwdFile(String pwdFile){
        domainTargetnssPwdFileMapping.put(currentDomain,pwdFile);
    }
    
    public void setInstallConfig70(String config) {
        InstallConfig70 = config;
    }
    
    public String getInstallConfig70() {
        return InstallConfig70;
    }
    public Map getTargetDomainNameMapping(){
        return domainNameMapping;
    }
    /**
     * @return a logger to use in the Module implementation classes
     */
    public static Logger getDefaultLogger() {
        if (logger==null) {
            logger = LogService.getLogger(LogService.UPGRADE_LOGGER);
        }
        return logger;
    }
    
    public boolean isUpgradeJKStoJKS() {
        if (getTargetEdition().equals(UpgradeConstants.EDITION_PE)) {
            if (getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_PE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_PE)) {
                return true;
            }
        }
        return false;
    }
    
    public boolean isUpgradeJKStoNSS() {
        if (getTargetEdition().equals(UpgradeConstants.EDITION_EE) ||
                getTargetEdition().equals(UpgradeConstants.EDITION_SE)) {
            if (getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_PE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_PE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)) {
                return true;
            }
        }
        return false;
    }
    
    public boolean isUpgradeNSStoNSS() {
        if (getTargetEdition().equals(UpgradeConstants.EDITION_EE) ||
                getTargetEdition().equals(UpgradeConstants.EDITION_SE)) {
            if (getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_PE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_SE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_EE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_EE)) {
                return true;
            }
        }
        return false;
    }
    
    public boolean isUpgradeNSStoJKS() {
        if (getTargetEdition().equals(UpgradeConstants.EDITION_PE)) {            
            if (getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_PE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_SE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_EE) ||
                    getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_EE)){
                return true;
            }
        }
        return false;
    }
    
    public boolean  checkUpgradefrom7xeeto9xee() {
        boolean checkUpgradefrom7xeeto8xee = false;
        if(this.getSourceInstallDir() != null && this.getTargetInstallDir() != null)   {
            checkUpgradefrom7xeeto8xee = this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_EE) && this.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_EE);
        }
        return checkUpgradefrom7xeeto8xee;
    }
    
    //START CR 6397215
    public boolean  checkUpgradefrom8xpeto90pe() {
        boolean checkUpgradefrom8xpeto90pe = false;
        if(this.getSourceInstallDir() != null && this.getTargetInstallDir() != null)   {
            checkUpgradefrom8xpeto90pe = (this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_PE) ||
                                          this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_PE) ||
                                          this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS82_PE)) &&
                                          this.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE);
        }
        return checkUpgradefrom8xpeto90pe;
    }
    //END CR 6397215
    
    public void enlistDomainsFromSource(java.util.List domains){
        if(domains == null)
            this.enlistDomainsFromSource();
        if(enlistDomain)
            return;
        this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomainsFromUserDefinedDirectories(domains));
        this.enlistDomain=true;
    }
    
    public void enlistDomainsFromSource(){
        if( getSourceInstallDir() == null) {
            return;
        }
        if(enlistDomain)
            return;
        if(this.getSourceVersion().equals(UpgradeConstants.VERSION_7X)){
            this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlist70DomainsFromSource(this));
        }else{
            // Determine domains from domains directory....
            if(sourceIsDomain()){
                String source = getSourceInstallDir();
                if(source.endsWith(File.separator)) {
                    source = source.substring(0,source.length() - File.separator.length());
                }
                String domainName = source.substring(source.lastIndexOf(File.separator) + File.separator.length(), source.length());
                String domainRoot = source.substring(0,source.lastIndexOf(domainName) - File.separator.length());
                setSourceDomainRoot(domainRoot);
                setTargetDomainRoot(domainRoot);
                setSourceDomainRootFlag(true);
                setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomains(this, new String [] {domainName}, domainRoot));
            } else {
                if(this.getSourceDomainRootFlag()) {
                    setSourceDomainRoot(this.getSourceInstallDir());
                } else {
                    setSourceDomainRoot(this.getSourceInstallDir()+File.separator+"domains");
                }
                this.setDomainMapping(UpgradeUtils.getUpgradeUtils(this).enlistDomainsFromDomainsDirectory(this,this.getSourceDomainRoot()));
            }
            enlistDomain=true;
        }
    }
    
    private boolean sourceIsDomain() {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomain();
    }
    public boolean checkSourceInputAsDomainRoot(String source) {
        return UpgradeUtils.getUpgradeUtils(this).checkSourceInputAsDomainRoot(source,this);
    }
    public boolean isValid70Domain(String domainPath) {
        return UpgradeUtils.getUpgradeUtils(this).isValid70Domain(domainPath);
    }
    
    //Added by Prasad
    public boolean isDomain(String domainPath) {
       return UpgradeUtils.getUpgradeUtils(this).isDomain(domainPath);  
    }
    
    public boolean getSourceDomainRootFlag() {
        return sourceInputAsDomainRoot;
    }
    // This method is called by UpgradeUtils
    public void setSourceDomainRootFlag(boolean fl) {
        this.sourceInputAsDomainRoot = fl;
    }
    public void printInfo(){
        
        getDefaultLogger().finest("SOURCE_INSTALL_DIR=="+SOURCE_INSTALL_DIR);
        getDefaultLogger().finest("SOURCE_INSTALL_DIR=="+TARGET_INSTALL_DIR);
        int size = domainList.size();
        for(int i=0;i<size;i++) {
            String domainName = (String)domainList.get(i);
            getDefaultLogger().finest("**********" + domainName + "****************");
            getDefaultLogger().finest("NSSPWD=="+ domainNSSPwdMapping.get(domainName));
            getDefaultLogger().finest("JKSPWD=="+ domainJKSPwdMapping.get(domainName));
            getDefaultLogger().finest("********************************************");
        }
        
    }
    public String getSourceServerPolicyFileName(){
        if(this.getSourceVersion().equals(UpgradeConstants.VERSION_7X)){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"server.policy" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"server.policy" ;
        }
        // return getSourceInstancePath()+File.separator+"config"+File.separator+"server.policy" ;
    }
    public String getTargetServerPolicyFileName(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"server.policy" ;
    }
    public String getSourceDefaultWebXMLFileName(){
        if(this.getSourceVersion().equals(UpgradeConstants.VERSION_7X) || this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_SE)){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"default-web.xml" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"default-web.xml" ;
        }
        //return getSourceInstancePath()+File.separator+"config"+File.separator+"default-web.xml" ;
    }
    public String getTargetDefaultWebXMLFileName(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"default-web.xml" ;
    }
    public String getSourceSunACCFileName(){
        if(this.getSourceVersion().equals(UpgradeConstants.VERSION_7X) || this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_SE)){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
        }
        //return getSourceInstancePath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
    }
    public String getTargetSunACCFileName(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"sun-acc.xml" ;
    }
    public String getSourceConfigXMLFile(){
        if(this.getSourceVersion().equals(UpgradeConstants.VERSION_7X) || this.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_SE)){
            return getSourceInstancePath()+File.separator+"config"+File.separator+"server.xml" ;
        }else{
            return getSourceDomainPath()+File.separator+"config"+File.separator+"domain.xml" ;
        }
    }
    public String getTargetConfigXMLFile(){
        return getDestinationDomainPath()+File.separator+"config"+File.separator+"domain.xml" ;
    }
    
    public String getSourceVersionAndEdition(){
        if(this.sourceVersionEdition == null){
            if(getSourceInstallDir() != null){
                this.sourceVersionEdition = new VersionExtracter(this.getSourceInstallDir(),this).getVersion();
            } else {
                return "UNKNOWN";
            }
        }
        return this.sourceVersionEdition;
    }
    public String getTargetVersionAndEdition(){
        /*if(this.targetVersionEdition == null){
            this.targetVersionEdition = new VersionExtracter(this.getTargetInstallDir(),this).getVersion();
        }*/
        return this.targetVersionEdition;
    }
    public void setTargetVersionAndEdition(String verEd){
        // This method is called from UpgradeToolMain
        if(verEd.equals("AS90PE")){
            this.targetVersionEdition = UpgradeConstants.VERSION_AS90_PE;
        }else{
            // There is no difference between SE and EE
            this.targetVersionEdition = UpgradeConstants.VERSION_AS90_EE;
        }
    }
    public void clearSourceAndTargetVersions(){
        // this method is called from MainFrame.java.  Need to set this to null after validation is done.
        this.sourceVersionEdition = null;
        //this.targetVersionEdition = null;
    }
    public String getSourceVersion(){
        return UpgradeUtils.getUpgradeUtils(this).versionString(this.getSourceVersionAndEdition());
    }
    public String getTargetVersion(){
        return UpgradeUtils.getUpgradeUtils(this).versionString(this.getTargetVersionAndEdition());
    }
    public String getSourceEdition(){
        return UpgradeUtils.getUpgradeUtils(this).editionString(this.getSourceVersionAndEdition());
    }
    public String getTargetEdition(){
        return UpgradeUtils.getUpgradeUtils(this).editionString(this.getTargetVersionAndEdition());
    }
    public boolean isUpgradeSupported(){
        if (getSourceVersionAndEdition().equals(getTargetVersionAndEdition())) {
            logger.info(stringManager.getString("sameVersionUpgradeNotRequired"));
            return false;
        }
        return ((java.util.HashSet)UpgradeConstants.supportMap.get(getSourceVersionAndEdition())).contains(getTargetVersionAndEdition());
    }
    public boolean isUpgradeSupported(String src, String targ){
        if(src.equals(targ)) return false;
        return ((java.util.HashSet)UpgradeConstants.supportMap.get(src)).contains(targ);
    }
    public boolean extractVersionDetails(){
        this.sourceVersionEdition = new VersionExtracter(this.getSourceInstallDir(),this).getVersion();
        //this.targetVersionEdition = new VersionExtracter(this.getTargetInstallDir(),this).getVersion();
        if((this.sourceVersionEdition == null) || (this.targetVersionEdition == null))
            return false;
        return true;
    }
    public String getCurrentCluster(){
        return this.currentCluster;
    }
    public void setCurrentCluster(String clu){
        this.currentCluster = clu;
    }
    public String findLatestDomainDir(String domainRoot) {
        return UpgradeUtils.getUpgradeUtils(this).findLatestDomainDir(domainRoot,currentDomain);
    }
    public String getAdminUserName(){
        return this.adminUserName;
    }
    
    public void setAdminUserName(String adminUserName){
        this.adminUserName=adminUserName ;
    }
    
    public String getAdminPassword(){
        return this.adminPassword;
    }
    
    public void setAdminPassword(String adminPassword){
        this.adminPassword = adminPassword;
    }
    
    public String getPasswordFile() {
        if (passwordFilePath == null) {
            try {
                passwordFile = java.io.File.createTempFile("ugpw", null);
                FileWriter writer = new FileWriter(passwordFile);
                writer.write("AS_ADMIN_PASSWORD=" + getAdminPassword() +"\n");
                writer.write("AS_ADMIN_ADMINPASSWORD=" + getAdminPassword() +"\n");
                writer.write("AS_ADMIN_MASTERPASSWORD=" + getMasterPassword() + "\n");
                writer.close();
                passwordFilePath = passwordFile.getAbsolutePath();
            } catch (IOException ioe) {
                logger.severe(stringManager.getString("command.generalException") + " " + ioe.getMessage());
                
            }
        }
        return passwordFilePath;
    }
    
    public void setPasswordsFromFile(String path) {
        try {
            File userPasswordFile = new File(path);
            BufferedReader reader = new BufferedReader(new FileReader(userPasswordFile));
            while( reader.ready() ) {
                String line = reader.readLine();
                if ( line.startsWith("AS_ADMIN_PASSWORD=") ) {
                    setAdminPassword(line.substring(line.indexOf("=") + 1));
                } else if ( line.startsWith("AS_ADMIN_ADMINPASSWORD=") ) {
                    setAdminPassword(line.substring(line.indexOf("=") + 1));
                } else if ( line.startsWith("AS_ADMIN_MASTERPASSWORD=") ) {
                    setMasterPassword(line.substring(line.indexOf("=") + 1));
                }
            }
            reader.close();
        } catch (Exception e) {
            logger.severe(stringManager.getString("command.generalException") + " " + e.getMessage());
        }
    }
    
    public void setMasterPassword(String pw) {
        masterPassword = pw;
    }
    public String getMasterPassword() {
        return masterPassword;
    }
    
    public void deletePasswordFile() {
        if (passwordFile != null) {
            passwordFile.delete();
        }
    }
    
    public String getSourceInitConfFileName(){
        if(this.getSourceVersion().equals(UpgradeConstants.VERSION_7X)) {
            return getSourceInstancePath()+File.separator+"config"+File.separator+"init.conf" ;
        }else{
            return null;
        }
    }
    
    public void recover() {
        UpgradeUtils.getUpgradeUtils(this).recover();
    }
    public boolean processClinstnceConfFiles(Vector files){
        return ClustersInfoManager.getClusterInfoManager().processClinstanceConfFiles(files);
    }
}
