/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common;

import java.util.*;

/**
 *
 * author : Gautam Borah
 *
 */

public class CommonProperties{
    
    private static final String TRANSFORMATION_MODULE = "com.sun.enterprise.tools.upgrade.transform.TransformManager";
    private static final String NSS_TO_JKS_MODULE = "com.sun.enterprise.tools.upgrade.certconversion.NSStoJKSConversionModule";
    private static final String JKS_TO_JKS_MODULE = "com.sun.enterprise.tools.upgrade.certconversion.JKStoJKSConversionModule";
    private static final String NSS_TO_NSS_MODULE = "com.sun.enterprise.tools.upgrade.certconversion.NSStoNSSConversionModule";
    private static final String JKS_TO_NSS_MODULE = "com.sun.enterprise.tools.upgrade.certconversion.JKStoNSSConversionModule";
    private static final String REALM_MODULE = "com.sun.enterprise.tools.upgrade.realm.RealmUpgrade";
    private static final String DEPLOYMENT_MODULE = "com.sun.enterprise.tools.upgrade.deployment.DeploymentUpgrade";
    private static final String MISC_MODULE = "com.sun.enterprise.tools.upgrade.miscconfig.ConfigTransfers";
    
    /*
      Add your module to the linked list by calling add() method. Please make sure you maintain the order
     */
    
    public static List getRegisteredModules(CommonInfoModel model){
        List list = new LinkedList();
        list.add(TRANSFORMATION_MODULE);
        
        if(model.getCertificateConversionFlag()){
            if (model.getTargetEdition().equals(UpgradeConstants.EDITION_PE)){
                if (model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_PE) ||
                    model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_SE) ||
                    model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_EE) ||
                    model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_EE)) {
                    list.add(NSS_TO_JKS_MODULE);
                } else if (model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_PE) ||
                           model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_PE)) {
                    list.add(JKS_TO_JKS_MODULE);
                }
            } else if (model.getTargetEdition().equals(UpgradeConstants.EDITION_EE) || 
                       model.getTargetEdition().equals(UpgradeConstants.EDITION_SE)){
                if (model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_PE) ||
                    model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_SE) ||
                    model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS7X_EE) ||
                    model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_EE)) {
                    list.add(NSS_TO_NSS_MODULE);
                } else if (model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS80_PE) ||
                           model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS81_PE)||
                           model.getSourceVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)) {
                    list.add(JKS_TO_NSS_MODULE);
                }
            }
        }
        list.add(MISC_MODULE);
        list.add(DEPLOYMENT_MODULE);
        list.add(REALM_MODULE);
        return list;
    }
}
