/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * UpdateProgressManager.java
 *
 * Created on February 12, 2004, 12:37 PM
 */

package com.sun.enterprise.tools.upgrade.common ;

/**
 *
 * @author  prakash
 */

import java.util.*;

public class UpdateProgressManager {
    
    private java.util.Vector upgradeUpdateListeners = null;
    private static UpdateProgressManager updateProgressManager = null;
    
    // In any event of errors this boolean will be set to false by any module.
    // If this state is set to false, the upgrade process will be aborted.
    // Currently UpgradeHarness checks to see if this state is GREEN
    private boolean continueUpgrade = true;
    
    /** Creates a new instance of UpdateProgressManager */
    private UpdateProgressManager() {
        upgradeUpdateListeners = new java.util.Vector();
    }
    public static UpdateProgressManager getProgressManager(){
        if(updateProgressManager == null)
            updateProgressManager = new UpdateProgressManager();
        return updateProgressManager;
    }
    public void addUpgradeUpdateListener(UpgradeUpdateListener listener){
        this.upgradeUpdateListeners.addElement(listener);
    }
    public void removeUpgradeUpdateListener(UpgradeUpdateListener listener){
        this.upgradeUpdateListeners.removeElement(listener);
    }
    /*
     * This is needed to send  back gui the finish action.
     */
    public void processUpgradeUpdateEvent(int progressState){
        UpgradeUpdateEvent de = new UpgradeUpdateEvent(this, progressState);
        de.setProgressState(progressState);
        for(int i=0 ; i<this.upgradeUpdateListeners.size(); i++){
            ((UpgradeUpdateListener)upgradeUpdateListeners.elementAt(i)).upgradeProcessUpdate(de);
        }
    }    
    public void setContinueUpgrade(boolean state){
        this.continueUpgrade = state;
    }
    public boolean canContinueUpgrade(){
        return this.continueUpgrade;
    }
    
}
