/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * UpgradeConstants.java
 *
 * Created on March 10, 2004, 3:24 PM
 */

package com.sun.enterprise.tools.upgrade.common;

/**
 *
 * @author  prakash
 */
import java.util.HashMap;
import java.util.HashSet;
import com.sun.enterprise.util.i18n.StringManager;
public final class UpgradeConstants {
    
    private static StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.common");
    
    /** Creates a new instance of UpgradeConstants */
    public UpgradeConstants() {
    }
    public static final String VERSION_AS7X_PE = "as7xpe";
    public static final String VERSION_AS7X_SE = "as7xse";
    public static final String VERSION_AS7X_EE = "as7xee";
    
    public static final String VERSION_AS80_PE = "as80pe";
    public static final String VERSION_AS81_PE = "as81pe";
    public static final String VERSION_AS80_SE = "as81se";
    public static final String VERSION_AS81_EE = "as81ee";
    
    public static final String VERSION_AS82_PE = "as82pe";
    public static final String VERSION_AS82_SE = "as82se";
    public static final String VERSION_AS82_EE = "as82ee";
    
    public static final String VERSION_AS90_PE = "as90pe";
    public static final String VERSION_AS90_SE = "as90se";
    public static final String VERSION_AS90_EE = "as90ee";
    
    public static final String EDITION_PE = "pe";
    public static final String EDITION_SE = "se";
    public static final String EDITION_EE = "ee";
    
    public static final String VERSION_7X = "7x";
    public static final String VERSION_80 = "80";
    public static final String VERSION_81 = "81";
    public static final String VERSION_90 = "90";
    
    public static final HashMap supportMap = new HashMap();
    static{
        HashSet x7PESet = new HashSet();
        x7PESet.add(VERSION_AS90_PE);
        x7PESet.add(VERSION_AS90_SE);
        x7PESet.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS7X_PE,x7PESet);
        
        HashSet x7SESet = new HashSet();
        x7SESet.add(VERSION_AS90_SE);
        x7SESet.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS7X_SE,x7SESet);
        
        HashSet x7EESet = new HashSet();
        x7EESet.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS7X_EE,x7EESet);
        
        HashSet pE80Set = new HashSet();
        pE80Set.add(VERSION_AS90_PE);
        pE80Set.add(VERSION_AS90_SE);
        pE80Set.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS80_PE,pE80Set);

        HashSet eE80Set = new HashSet();
        eE80Set.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS80_SE,eE80Set); 
        
        HashSet pE81Set = new HashSet();
        pE81Set.add(VERSION_AS90_PE);
        pE81Set.add(VERSION_AS90_SE);
        pE81Set.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS81_PE,pE81Set);
        
        HashSet eE81Set = new HashSet();
        eE81Set.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS81_EE,eE81Set);  
        
        HashSet pE90Set = new HashSet();
        pE90Set.add(VERSION_AS90_SE);
        pE90Set.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS90_PE,pE90Set);
        
        HashSet sE90Set = new HashSet();
        sE90Set.add(VERSION_AS90_EE);
        supportMap.put(VERSION_AS90_SE,sE90Set);
        
        HashSet eE90Set = new HashSet();
        supportMap.put(VERSION_AS90_EE,eE90Set);
    };
    
    /*
     * Returns readable strings for user output that maps to version and edition strings.
     */
    public static String readableString(String ve){
        return stringManager.getString("upgradeConstants."+ve);        
    }
}
