/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;

/**
 *
 * @author Hans Hrasna
 */
public class ARG_jkspwdfile extends CertificateArgumentHandler {
    private String jksPwdFile;
    /**
     * Creates a new instance of ARG_jkspwdfile
     */
    public ARG_jkspwdfile(ParsedArgument pa) {
        super(pa);
        if (parameters.isEmpty()) {
            helpUsage(sm.getString("enterprise.tools.upgrade.cli.argument_missing", "--jkspwdfile/-j"));
            System.exit(1);
        }
        jksPwdFile = (String)parameters.firstElement();
        processCertificatePasswords(jksPwdFile);       
    }
    
    protected void setCertificatePassword(String password) {
       if(password == null) {
            _logger.severe(sm.getString("enterprise.tools.upgrade.cli.password_error",jksPwdFile));
            System.exit(1);
        }
        commonInfo.setJksKeystorePassword(password);
        String jksPath="";
        if(commonInfo.isUpgradeNSStoJKS()){
            if(!interactiveMap.containsKey("target"))
                return;
            jksPath=commonInfo.getTargetJKSKeyStorePath();
        } else {
            if(!interactiveMap.containsKey("source"))
                return;
            jksPath=commonInfo.getSourceJKSKeyStorePath();
        }
        boolean validpwd = PasswordVerifier.verifyKeystorePassword(jksPath,password);
        if(!validpwd) {
            commonInfo.recover();
            _logger.severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
            System.exit(1);
        }
        interactiveMap.put(ArgsParser.JKSPWD + "-" + commonInfo.getCurrentDomain(), jksPwdFile);        
    }
}
